;*** SineWave.asm ***;
;-------------------------------------------------
 .def R_SAMPLES     = R0
 .def R_SAMPLES+1   = R1
 .def R_PSTACK      = R6
 .def R_PSTACK+1    = R7
 .def R_PPARAMS     = R10
 .def R_PPARAMS+1   = R11
 .def R_TEMP        = R16
 .def R_PWAVE       = R22
 .def R_PWAVE+1     = R23
 .def R_COUNT       = R24
 .def R_COUNT+1     = R25
 .def R_POSITION    = R26
 .def R_POSITION+1  = R27
 .def R_T_POINTER   = R30
 .def R_T_POINTER+1 = R31
;-------------------------------------------------
; PCF 8591
; slave address (3 X low) and write
 .equ SLA_W      = 0b10010000
; slave control byte
 .equ SL_CONTROL = 0b01000000
;------------------------------------------------
; TWCR - TWI Control Register
 .equ TWIE  = 0 ; TWI Interrupt Enable
 .equ TWEN  = 2 ; TWI Enable Bit
 .equ TWWC  = 3 ; TWI Write Collition Flag
 .equ TWSTO = 4 ; TWI Stop Condition Bit
 .equ TWSTA = 5 ; TWI Start Condition Bit
 .equ TWEA  = 6 ; TWI Enable Acknowledge Bit
 .equ TWINT = 7 ; TWI Interrupt Flag
; Sample Rates
; 0x0A = 43825 Hz
 .equ TWI_BIT_RATE  = 0x0A ; (10 ... 255)
 .equ TWI_PRESCALER = 0x00 ; (0 = 1), (1 = 4), (2 = 16), (3 = 64)
 .equ START         = 0x08 ; A START condition has been transmitted.
 .equ MT_SLA_ACK    = 0x18 ; SLA_W has been transmitted ACK has been received.
 .equ MT_DATA_ACK   = 0x28 ; Data byte has been transmitted ACK has been received.
;-------------------------------------------------
 .ifdef __MEGA32__
;-------------------------------------------------
 .equ TWBR = 0x00 ; Bit Rate Register
 .equ TWSR = 0x01 ; Status Register
 .equ TWAR = 0x02 ; Address Register
 .equ TWDR = 0x03 ; Address/Data Shift Register
 .equ TWCR = 0x36 ; Control Register
;-------------------------------------------------
 .MACRO STORE_CR
    out TWCR, R_TEMP
 .ENDMACRO
;-------------------------------------------------
 .MACRO LOAD_CR
    in R_TEMP, TWCR
 .ENDMACRO
;-------------------------------------------------
 .MACRO LOAD_SR
    in R_TEMP, TWSR
 .ENDMACRO
;-------------------------------------------------
 .MACRO STORE_DR
    out TWDR, R_TEMP
 .ENDMACRO
;-------------------------------------------------
 SineWaveInit:
    push R_TEMP
    ldi  R_TEMP, TWI_BIT_RATE
    out  TWBR,   R_TEMP
    ldi  R_TEMP, TWI_PRESCALER
    out  TWSR,   R_TEMP
    pop  R_TEMP
    ret
;-------------------------------------------------
 .elif __MEGA128__
;-------------------------------------------------
 .equ TWBR = 0x70 ; Bit Rate Register
 .equ TWSR = 0x71 ; Status Register
 .equ TWAR = 0x72 ; Address Register
 .equ TWDR = 0x73 ; Address/Data Shift Register
 .equ TWCR = 0x74 ; Control Register
;-------------------------------------------------
 .MACRO STORE_CR
    sts TWCR, R_TEMP
 .ENDMACRO
;-------------------------------------------------
 .MACRO LOAD_CR
    lds R_TEMP, TWCR
 .ENDMACRO
;-------------------------------------------------
 .MACRO LOAD_SR
    lds R_TEMP, TWSR
 .ENDMACRO
;-------------------------------------------------
 .MACRO STORE_DR
    sts TWDR, R_TEMP
 .ENDMACRO
;-------------------------------------------------
 SineWaveInit:
    push R_TEMP
    ldi  R_TEMP, TWI_BIT_RATE
    sts  TWBR,   R_TEMP
    ldi  R_TEMP, TWI_PRESCALER
    sts  TWSR,   R_TEMP
    pop  R_TEMP
    ret
 .endif
;-------------------------------------------------
 .ifdef TagSineWaveOut
 SineWaveOut:
    push R_TEMP
    movw R_T_POINTER, R_PPARAMS
; 3. Parameter = w_repetitions
    ld   R_COUNT,     Z+
    ld   R_COUNT+1,   Z+
; 2. Parameter = w_samples
    ld   R_SAMPLES,   Z+
    ld   R_SAMPLES+1, Z+
; 1. Parameter = pointer wave
    ld   R_PWAVE,     Z+
    ld   R_PWAVE+1,   Z
;-------------------------------------------------
; Send START condition.
    ldi  R_TEMP, (1 << TWINT) | (1 << TWSTA) | (1 << TWEN)
    STORE_CR
;-------------------------------------------------
; Wait for TWINT flag set. This indicates that
; the START condition has been transmitted.
 LOOP_SWO_WAIT_1:
    LOAD_CR
    sbrs R_TEMP, TWINT
    rjmp LOOP_SWO_WAIT_1
;-------------------------------------------------
; Check value of TWI Status Register. Mask prescaler bits.
; If status different from START go to END_SWO.
    LOAD_SR
    andi R_TEMP, 0xF8
    cpi  R_TEMP, START
    brne END_SWO
;-------------------------------------------------
; Load SLA_W into TWDR Register. Clear TWINT bit
; in TWCR to start transmission of address.
    ldi R_TEMP, SLA_W
    STORE_DR
    ldi R_TEMP, (1 << TWINT) | (1 << TWEN)
    STORE_CR
;-------------------------------------------------
; Wait for TWINT flag set. This indicates that the SLA_W
; has been transmitted, and ACK/NACK has been received.
 LOOP_SWO_WAIT_2:
    LOAD_CR
    sbrs R_TEMP, TWINT
    rjmp LOOP_SWO_WAIT_2
;-------------------------------------------------
; Check value of TWI Status Register. Mask prescaler bits.
; If status different from MT_SLA_ACK go to END_SWO.
    LOAD_SR
    andi R_TEMP, 0xF8
    cpi  R_TEMP, MT_SLA_ACK
    brne END_SWO
;-------------------------------------------------
; Load SL_CONTROL into TWDR Register. Clear TWINT bit
; in TWCR to start transmission of data.
    ldi R_TEMP, SL_CONTROL
    STORE_DR
    ldi R_TEMP, (1 << TWINT) | (1 << TWEN)
    STORE_CR
;-------------------------------------------------
; Wait for TWINT flag set. This indicates that the SL_CONTROL
; has been transmitted, and ACK/NACK has been received.
 LOOP_SWO_WAIT_3:
    LOAD_CR
    sbrs R_TEMP, TWINT
    rjmp LOOP_SWO_WAIT_3
;-------------------------------------------------
; Check value of TWI Status Register. Mask prescaler bits.
; If status different from MT_DATA_ACK go to END_SWO.
    LOAD_SR
    andi R_TEMP, 0xF8
    cpi  R_TEMP, MT_DATA_ACK
    brne END_SWO
;-------------------------------------------------
 LOOP_SWO_REPET:
    movw R_T_POINTER, R_PWAVE
    movw R_POSITION,  R_SAMPLES
;-------------------------------------------------
 LOOP_SWO_SAMPLES:
;-------------------------------------------------
; Load data into TWDR Register. Clear TWINT bit
; in TWCR to start transmission of data.
    ld R_TEMP,  Z+
    STORE_DR
    ldi R_TEMP, (1 << TWINT) | (1 << TWEN)
    STORE_CR
;-------------------------------------------------
; Wait for TWINT flag set. This indicates that the data
; has been transmitted, and ACK/NACK has been received.
 LOOP_SWO_WAIT_4:
    LOAD_CR
    sbrs  R_TEMP, TWINT
    rjmp LOOP_SWO_WAIT_4
;-------------------------------------------------
; Check value of TWI Status Register. Mask prescaler bits.
; If status different from MT_DATA_ACK go to END_SWO.
    LOAD_SR
    andi R_TEMP, 0xF8
    cpi  R_TEMP, MT_DATA_ACK
    brne END_SWO
;-------------------------------------------------
; If corrections become necessary at the sample-rate,
; this can be done here.
;    ldi R_TEMP, 0x0F
; LOOP_SWO_WAIT_5:
;    nop
;    nop
;    nop
;    dec R_TEMP
;    brne LOOP_SWO_WAIT_5
;-------------------------------------------------
    sbiw R_POSITION, 0x0001
    brne LOOP_SWO_SAMPLES
;-------------------------------------------------
    sbiw R_COUNT,    0x0001
    brne LOOP_SWO_REPET
;-------------------------------------------------
; Transmit STOP condition.
    ldi  R_TEMP, (1 << TWINT) | (1 << TWEN) | (1 << TWSTO)
    STORE_CR
;-------------------------------------------------
 END_SWO:
    movw R_T_POINTER, R_PSTACK
    adiw R_T_POINTER, 4
    movw R_PSTACK,    R_T_POINTER
    st   Z+,          R_TEMP
    clr  R_TEMP
    st   Z+,          R_TEMP
    st   Z+,          R_TEMP
    st   Z,           R_TEMP
    pop  R_TEMP
    ret
 .endif
;-------------------------------------------------
