/*** DS2482.cc ***/
//------------------------------------------------
 #include "Definitions.h"
//------------------------------------------------
 BOOL TempConvInit(byte by_conv_write_addr)
    {
    int i_index;
    byte aby_rom_code[ROM_CODE_SIZE];
    byte by_checksum;
    byte aby_error[1];

    if(!TempConvReset(by_conv_write_addr))
        return false;

    if(!TempConvConfig(by_conv_write_addr))
        return false;

    if(!TempOneWireReset(by_conv_write_addr))
        return false;

    if(!TempOneWireWriteByte(by_conv_write_addr, CMD_OW_READ_ROM))
        return false;

    for(i_index = 0; i_index < ROM_CODE_SIZE; i_index++)
        {
        aby_error[0] = false;
        aby_rom_code[i_index] = TempOneWireReadByte(by_conv_write_addr, aby_error);
        if(aby_error[0])
            return false;
        }

    by_checksum = 0;
    for(i_index = 0; i_index < ROM_CODE_SIZE; i_index++)
        by_checksum = gaby_crc_table[by_checksum ^ aby_rom_code[i_index]];

    return (0x00 == by_checksum);
    }
//------------------------------------------------
 BOOL TempConvReset(byte by_conv_write_addr)
    {
    byte by_read;

    I2C_Start();
    if(I2C_M_START != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Write(by_conv_write_addr);
    if(I2C_MT_SLA_ACK != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Write(CMD_CONV_RESET);
    if(I2C_MT_DATA_ACK != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Start();
    if(I2C_REPEATED_START != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Write(by_conv_write_addr + 1);
    if(I2C_MR_SLA_ACK != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    by_read = I2C_Read_NACK();
    if(I2C_MR_DATA_NACK != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Stop();

    if(((1 << BIT_DEVICE_RESET) | (1 << BIT_LOGIC_LEVEL)) == by_read)
        return true;

    return false;
    }
//------------------------------------------------
 BOOL TempConvConfig(byte by_conv_write_addr)
    {
    byte by_read;
// For overdrive speed
    //byte by_config;
    //by_config = (1 << BIT_1WS);
    //by_config = ~by_config;
    //by_config = by_config << 4;
    //by_config = by_config | (1 << BIT_1WS);

    I2C_Start();
    if(I2C_M_START != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Write(by_conv_write_addr);
    if(I2C_MT_SLA_ACK != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Write(CMD_CONV_CONFIG);
    //I2C_Write(by_config);
    if(I2C_MT_DATA_ACK != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Write(0x00);
    if(I2C_MT_DATA_NACK != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Start();
    if(I2C_REPEATED_START != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Write(by_conv_write_addr + 1);
    if(I2C_MR_SLA_ACK != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    by_read = I2C_Read_NACK();
    if(I2C_MR_DATA_NACK != I2C_Status())
        {
        I2C_Stop();
        return false;
        }

    I2C_Stop();

    //if((1 << BIT_1WS) == by_read)
    if(0 == by_read)
        return true;

    return false;
    }
//------------------------------------------------
 float TempConvRead(byte by_conv_write_addr)
    {
    int i_index;
    int i_temp;
    float f_temp;
    float f_value;
    byte aby_scratchpad[SCRATCHPAD_SIZE];
    byte by_timeout;
    byte by_checksum;
    byte aby_error[1];

    if(!TempOneWireReset(by_conv_write_addr))
        return INVALID_VALUE;

    if(!TempOneWireWriteByte(by_conv_write_addr, CMD_OW_SKIP_ROM))
        return INVALID_VALUE;

    if(!TempOneWireWriteByte(by_conv_write_addr, CMD_OW_CONVERT))
        return INVALID_VALUE;

    by_timeout = 1;
    aby_error[0] = false;
    while(0xFF != TempOneWireReadByte(by_conv_write_addr, aby_error))
        {
        if((!by_timeout++) || aby_error[0])
            return INVALID_VALUE;
        }

    if(!TempOneWireReset(by_conv_write_addr))
        return INVALID_VALUE;

    if(!TempOneWireWriteByte(by_conv_write_addr, CMD_OW_SKIP_ROM))
        return INVALID_VALUE;

    if(!TempOneWireWriteByte(by_conv_write_addr, CMD_OW_READ_SCRATCHPAD))
        return INVALID_VALUE;

    aby_error[0] = false;
    for(i_index = 0; i_index < SCRATCHPAD_SIZE; i_index++)
        {
        aby_scratchpad[i_index] = TempOneWireReadByte(by_conv_write_addr, aby_error);
        if(aby_error[0])
            return INVALID_VALUE;
        }

    if(!TempOneWireReset(by_conv_write_addr))
        return INVALID_VALUE;

    by_checksum = 0x00;
    for(i_index = 0; i_index < SCRATCHPAD_SIZE; i_index++)
        by_checksum = gaby_crc_table[by_checksum ^ aby_scratchpad[i_index]];

    if(by_checksum)
        return INVALID_VALUE;

    i_temp = (aby_scratchpad[BYTE_TEMP_MSB] << 8);
    i_temp = i_temp | aby_scratchpad[BYTE_TEMP_LSB];
    i_temp = i_temp & 0xFFFE;
    f_temp = i_temp;
    f_temp = f_temp / 2.0;

    f_value = aby_scratchpad[BYTE_COUNT_PER_C] - aby_scratchpad[BYTE_COUNT_REMAIN];
    f_value = f_value / aby_scratchpad[BYTE_COUNT_PER_C];
    f_temp = f_temp + f_value;

    return f_temp;
    }
//------------------------------------------------
