/*** DS18S20.h ***/
//-----------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
 #ifndef __DALLAS_SEMICONDUCTOR_18S20__
 #define __DALLAS_SEMICONDUCTOR_18S20__
//-----------------------------------------------
 #define BOOL int
//-----------------------------------------------
 #define ROM_CODE_SIZE   8
 #define SCRATCHPAD_SIZE 9

/*** Rom commands ***/
 #define OW_READ_ROM     0x33
 #define OW_MATCH_ROM    0x55
 #define OW_SKIP_ROM     0xCC
 #define OW_SEARCH_ROM   0xF0
 #define OW_ALARM_SEARCH 0xEC

/*** Memory commands ***/
 #define OW_READ_SCRATCHPAD   0xBE
 #define OW_WRITE_SCRATCHPAD  0x4E
 #define OW_COPY_SCRATCHPAD   0x48
 #define OW_RECALL_SCRATCHPAD 0xB8
 #define OW_CONVERT           0x44
 #define OW_READ_POWER_SUPPLY 0xB4

/*** Scratchpad bytes ***/
 #define BYTE_TEMP_LSB     0
 #define BYTE_TEMP_MSB     1
 #define BYTE_TH           2
 #define BYTE_TL           3
 #define BYTE_RES_1        4
 #define BYTE_RES_2        5
 #define BYTE_COUNT_REMAIN 6
 #define BYTE_COUNT_PER_C  7
 #define BYTE_CRC          8

//------------------------------------------------
 #endif
//------------------------------------------------