/*** DemoDS1631.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. I2C.h / I2C.cc / I2C.asm
// 2. DS1631.h / DS1631.cc
/*** Please add the required files to your porject! ***/
//------------------------------------------------
// temperature outside    0b1001 1100
 #define TEMP_OUT_ADDR 0x9E
// temperature inside     0b1001 1100
 #define TEMP_IN_ADDR  0x9C
// temperature greenhouse 0b1001 1010
 #define TEMP_GH_ADDR  0x9A
//------------------------------------------------
 void main(void)
    {
    char ac_msg[40];
    float f_temperature;

    I2CInitialize(I2C_100kHz, 0x00);

    if(DS1631Init(TEMP_OUT_ADDR))
        Msg_WriteText("Auentemperatur -> OK\r");
    else
        Msg_WriteText("Auentemperatur -> ERROR\r");

    if(DS1631Init(TEMP_IN_ADDR))
        Msg_WriteText("Innentemperatur -> OK\r");
    else
        Msg_WriteText("Innentemperatur -> ERROR\r");

    if(DS1631Init(TEMP_GH_ADDR))
        Msg_WriteText("Gewchshaustemperatur -> OK\r");
    else
        Msg_WriteText("Gewchshaustemperatur -> ERROR\r");

    DS1631SendValue(TEMP_OUT_ADDR, 1);
    DS1631SendValue(TEMP_IN_ADDR, 2);
    DS1631SendValue(TEMP_GH_ADDR, 3);
    Thread_Delay(500);

    while(1)
        {
        f_temperature = DS1631Read(TEMP_OUT_ADDR);
        if(INVALID_VALUE != f_temperature)
            {
            Str_Printf(
                ac_msg,
                "Auentemperatur       : %5.2f C\r",
                f_temperature
                );
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText(
                "Auentemperatur       : FEHLER\r"
                );
            DS1631Reset(TEMP_OUT_ADDR);
            DS1631Init(TEMP_OUT_ADDR);
            }

        f_temperature = DS1631Read(TEMP_IN_ADDR);
        if(INVALID_VALUE != f_temperature)
            {
            Str_Printf(
                ac_msg,
                "Innentemperatur       : %5.2f C\r",
                f_temperature
                );
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText(
                "Innentemperatur       : FEHLER\r"
                );
            DS1631Reset(TEMP_IN_ADDR);
            DS1631Init(TEMP_IN_ADDR);
            }

        f_temperature = DS1631Read(TEMP_GH_ADDR);
        if(INVALID_VALUE != f_temperature)
            {
            Str_Printf(
                ac_msg,
                "Gewchshaustemperatur : %5.2f C\r",
                f_temperature
                );
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText(
                "Gewchshaustemperatur : FEHLER\r"
                );
            DS1631Reset(TEMP_GH_ADDR);
            DS1631Init(TEMP_GH_ADDR);
            }

        if(I2CErrorsCount(GET))
            {
            Msg_WriteText("Errors count: ");
            Msg_WriteWord(I2CErrorsCount(GET));
            Msg_WriteChar(13);
            }

        Msg_WriteChar(13);
        Thread_Delay(100);
        }
    }
//------------------------------------------------