/*** I2C.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "I2C.h"
//------------------------------------------------
 #ifdef MEGA32
    void I2CEnable  $asm("I2CLibMega32")  (byte by_bit_rate, byte by_prescaler);
    void I2CDisable $asm("I2CLibMega32")  (void);
 #elif MEGA128
    void I2CEnable  $asm("I2CLibMega128") (byte by_bit_rate, byte by_prescaler);
    void I2CDisable $asm("I2CLibMega128") (void);
 #elif MEAGA128CAN
    void I2CEnable  $asm("I2CLibMega128") (byte by_bit_rate, byte by_prescaler);
    void I2CDisable $asm("I2CLibMega128") (void);
 #endif
//------------------------------------------------
 byte I2CBitRate(byte by_bit_rate, byte by_rule)
    {
    static byte sby_bit_rate;

    if(SET == by_rule)
        sby_bit_rate = by_bit_rate;

    return sby_bit_rate;
    }
//------------------------------------------------
 byte I2CPrescaler(byte by_prescaler, byte by_rule)
    {
    static byte sby_prescaler;

    if(SET == by_rule)
        sby_prescaler = by_prescaler;

    return sby_prescaler;
    }
//------------------------------------------------
 word I2CErrorsCount(byte by_rule)
    {
    static word sw_errors;

    switch(by_rule)
        {
        case GET:
            break;
        case SET:
            sw_errors++;
            break;
        case RESET:
            sw_errors = 0x00;
            break;
        }

    return sw_errors;
    }
//------------------------------------------------
 BOOL I2CInitialize(byte by_bit_rate, byte by_prescaler)
    {
    Port_DataDirBit(POWER, PORT_OUT);

    I2CErrorsCount(RESET);
    I2CBitRate(by_bit_rate, SET);
    I2CPrescaler(by_prescaler, SET);
    I2CEnable(by_bit_rate, by_prescaler);

    Port_WriteBit(POWER, PORT_ON);
    Thread_Delay(10);
    return true;
    }
//------------------------------------------------
 BOOL I2CReset(void)
    {
    I2CDisable();
    I2CErrorsCount(RESET);

    Port_DataDirBit(SCL, PORT_OUT);
    Port_DataDirBit(SDA, PORT_OUT);
    Port_DataDirBit(POWER, PORT_OUT);

    Port_WriteBit(SCL, PORT_OFF);
    Port_WriteBit(SDA, PORT_OFF);
    Port_WriteBit(POWER, PORT_OFF);

    Thread_Delay(50);
    I2CEnable(
        I2CBitRate(0xFF, GET),
        I2CPrescaler(0x00, GET)
        );
    Port_WriteBit(POWER, PORT_ON);
    Thread_Delay(5);

    return true;
    }
//------------------------------------------------
 BOOL I2CRelease(void)
    {
    I2CDisable();
    I2CErrorsCount(RESET);

    Port_DataDirBit(SCL, PORT_OUT);
    Port_DataDirBit(SDA, PORT_OUT);
    Port_DataDirBit(POWER, PORT_OUT);

    Port_WriteBit(SCL, PORT_OFF);
    Port_WriteBit(SDA, PORT_OFF);
    Port_WriteBit(POWER, PORT_OFF);

    return true;
    }
//------------------------------------------------
 BOOL I2CTransmitData(
    byte by_write_address,
    byte p_data[],
    int i_count,
    BOOL bo_stop
    )
    {
    int i_position;

    Thread_Lock(1);
    I2C_Start();
    if(I2C_M_START != I2C_Status())
        {
        I2C_Stop();
        I2CErrorsCount(SET);
        return false;
        }

    I2C_Write(by_write_address);
    if(I2C_MT_SLA_ACK != I2C_Status())
        {
        I2C_Stop();
        I2CErrorsCount(SET);
        return false;
        }

    for(i_position = 0; i_position < i_count; i_position++)
        {
        I2C_Write(p_data[i_position]);
        if(I2C_MT_DATA_ACK != I2C_Status())
            {
            I2C_Stop();
            I2CErrorsCount(SET);
            return false;
            }
        }

    if(bo_stop)
        {
        I2C_Stop();
        Thread_Lock(0);
        }

    return true;
    }
//------------------------------------------------
 BOOL I2CReceiveData(
    byte by_read_address,
    byte p_data[],
    int i_count,
    BOOL bo_repeated_start
    )
    {
    int i_position;

    I2C_Start();
    if(bo_repeated_start)
        {
        if(I2C_REPEATED_START != I2C_Status())
            {
            I2C_Stop();
            I2CErrorsCount(SET);
            return false;
            }
        }
    else
        {
        Thread_Lock(1);
        if(I2C_M_START != I2C_Status())
            {
            I2C_Stop();
            I2CErrorsCount(SET);
            return false;
            }
        }

    I2C_Write(by_read_address);
    if(I2C_MR_SLA_ACK != I2C_Status())
        {
        I2C_Stop();
        I2CErrorsCount(SET);
        return false;
        }

    i_count--;
    for(i_position = 0; i_position < i_count; i_position++)
        {
        p_data[i_position] = I2C_Read_ACK();
        if(I2C_MR_DATA_ACK != I2C_Status())
            {
            I2C_Stop();
            I2CErrorsCount(SET);
            return false;
            }
        }

    p_data[i_position] = I2C_Read_NACK();
    if(I2C_MR_DATA_NACK != I2C_Status())
        {
        I2C_Stop();
        I2CErrorsCount(SET);
        return false;
        }

    I2C_Stop();
    Thread_Lock(0);
    return true;
    }
//------------------------------------------------