/*** DS1631.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "DS1631.h"
//------------------------------------------------
 BOOL DS1631Init(byte by_write_addr)
    {
    byte aby_data[2];

    aby_data[0] = DS1631_ACCESS_CONFIG;
// Set resolution bit R0 and R1 = 12 bit resolution
    aby_data[1] = 0x0C;
    if(!I2CTransmitData(by_write_addr, aby_data, 2, true))
        return false;

    aby_data[0] = DS1631_START_CONVERT_T;
    if(!I2CTransmitData(by_write_addr, aby_data, 1, true))
        return false;

    Thread_Delay(75);

    aby_data[0] = DS1631_READ_TEMPERATURE;
    if(!I2CTransmitData(by_write_addr, aby_data, 1, false))
        return false;
    aby_data[0] = 0x80;
    aby_data[1] = 0x0F;
    if(!I2CReceiveData(by_write_addr + 1, aby_data, 2, true))
        return false;

    if(0x80 == aby_data[0])
        return false;
    if(0x0F & aby_data[1])
        return false;

    return true;
    }
//------------------------------------------------
 BOOL DS1631Reset(byte by_write_addr)
    {
    byte aby_data[1];

    aby_data[0] = DS1631_SOFTWARE_POR;
    if(!I2CTransmitData(by_write_addr, aby_data, 1, true))
        return false;

    return true;
    }
//------------------------------------------------
 float DS1631Read(byte by_write_addr)
    {
    byte aby_data[2];
    byte by_pos;
    byte by_read_addr;
    float f_temperature;
    float f_div;

    aby_data[0] = DS1631_READ_TEMPERATURE;
    if(!I2CTransmitData(by_write_addr, aby_data, 1, false))
        return INVALID_VALUE;

    by_read_addr = by_write_addr + 1;
    aby_data[0] = 0x80;
    aby_data[1] = 0x0F;
    if(!I2CReceiveData(by_read_addr, aby_data, 2, true))
        return INVALID_VALUE;

    if(0x80 == aby_data[0])
        return INVALID_VALUE;
    if(0x0F & aby_data[1])
        return INVALID_VALUE;

    f_temperature = aby_data[0];
    by_pos = 7;
    for(f_div = 2.0; f_div <= 16.0; f_div = f_div * 2.0)
        {
        if((1 << by_pos) & aby_data[1])
            f_temperature = f_temperature + (1.0 / f_div);
        by_pos--;
        }

    if((DS1631_MIN_VALUE < f_temperature) && (DS1631_MAX_VALUE > f_temperature))
        return f_temperature;

    return INVALID_VALUE;
    }
//------------------------------------------------
 void DS1631SendValue(byte by_write_addr, int i_device_number)
    {
    char ac_msg[30];
    float f_temperature;

    f_temperature = DS1631Read(by_write_addr);
    if(INVALID_VALUE != f_temperature)
        Str_Printf(
            ac_msg,
            "%d. Temperature: %5.2f\r",
            i_device_number,
            f_temperature
            );
    else
        Str_Printf(ac_msg, "%d. Temperature: ERROR\r", i_device_number);

    Msg_WriteText(ac_msg);
    }
//------------------------------------------------