/*** SetSecondI2CAddress.cc ***/
//------------------------------------------------
// Copyright (C) 2012 by Torsten Knorr
// create-soft@freenet.de
// All rights reserved!
// Permission is hereby granted to modify or enhance this sample code.
// This source code is provided "as is" and without any express or
// implied warranties, including, without limitation, the implied
// warranties of merchantibility and fitness for a particular purpose.
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. I2C.h / I2C.cc / I2C.asm
// 2. SensorConditioner.h / SensorConditioner.cc
/*** Please add the required files to your porject! ***/
//------------------------------------------------
 //#define ADDRESS_TO_SET SECOND_WRITE_ADDR1
 //#define ADDRESS_TO_SET SECOND_WRITE_ADDR2
 #define ADDRESS_TO_SET SECOND_WRITE_ADDR3
//------------------------------------------------
 void main(void)
    {
    char ac_msg[30];
    byte aby_data[3];
    word w_test;

    I2CInitialize(I2C_100kHz, 0x00);
    if(SensorInit(DEFAULT_WRITE_ADDR))
        Msg_WriteText("Sensor -> OK\r");
    else
        {
        Msg_WriteText("Sensor -> ERROR\r");
        I2CRelease();
        return;
        }

    if(SensorSetSecondAddress(DEFAULT_WRITE_ADDR, ADDRESS_TO_SET))
        {
        Msg_WriteText("Second Address -> OK\r");
        }
    else
        {
        Msg_WriteText("Second Address -> ERROR\r");
        I2CRelease();
        return;
        }

    Thread_Delay(100);
    I2CRelease();
    Thread_Delay(100);
    I2CReset();
    if(SensorInit(ADDRESS_TO_SET))
        Msg_WriteText("new address -> OK\r");
    else
        Msg_WriteText("new address -> ERROR\r");

    Str_Printf(
        ac_msg,
        "actual config: %x\r",
        SensorReadWord(ADDRESS_TO_SET, READ_RAM1_CFGSIF)
        );
    Msg_WriteText(ac_msg);

    I2CRelease();
    }
//------------------------------------------------