/*** DemoWatchDog.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. WatchDog.asm
// 2. WatchDog.cc
/*** Please add the required files to your porject! ***/
//------------------------------------------------
 #define PORT_HIGH 1
 #define PORT_LOW  0
//------------------------------------------------
 void VeryShortPeriodFunction(void)
    {
    Port_ToggleBit(PORT_LED2);
    }
//------------------------------------------------
 void ShortPeriodFunction(void)
    {
    Port_ToggleBit(PORT_LED2);
    Thread_Delay(4);
    }
//------------------------------------------------
 void NormalPeriodFunction(void)
    {
    int i_count;

    for(i_count = 0; i_count < 7; i_count++)
        {
        Port_ToggleBit(PORT_LED2);
        Thread_Delay(20);
        }
    }
//------------------------------------------------
 void LongPeriodFunction(void)
    {
    int i_count;

    for(i_count = 0; i_count < 20; i_count++)
        {
        Port_ToggleBit(PORT_LED2);
        Thread_Delay(100);
        }
    }
//------------------------------------------------
 void ShowTimePeriod(void)
    {
    char ac_msg[8];
    word w_time;

    ac_msg = " ms\r";

    Timer_TickCount();
    VeryShortPeriodFunction();
    w_time = Timer_TickCount();
    Msg_WriteText("VeryShortPeriodFunction = ");
    Msg_WriteWord(w_time * 10);
    Msg_WriteText(ac_msg);

    Timer_TickCount();
    ShortPeriodFunction();
    w_time = Timer_TickCount();
    Msg_WriteText("ShortPeriodFunction = ");
    Msg_WriteWord(w_time * 10);
    Msg_WriteText(ac_msg);

    Timer_TickCount();
    NormalPeriodFunction();
    w_time = Timer_TickCount();
    Msg_WriteText("NormalPeriodFunction = ");
    Msg_WriteWord(w_time * 10);
    Msg_WriteText(ac_msg);

    Timer_TickCount();
    LongPeriodFunction();
    w_time = Timer_TickCount();
    Msg_WriteText("LongPeriodFunction = ");
    Msg_WriteWord(w_time * 10);
    Msg_WriteText(ac_msg);
    }
//------------------------------------------------
 void NormalOperation(void)
    {
    int i_count;

    for(i_count = 0; i_count < 10; i_count++)
        {
        NormalPeriodFunction();
        WatchDogReset();
        }
    }
//------------------------------------------------
 void main(void)
    {
    int i_test_nr;
    int i_count;

// program is restated again
    Port_DataDirBit(PORT_LED1, PORT_OUT);
    Port_DataDirBit(PORT_LED2, PORT_OUT);

 #ifdef MEGA128
    if(WatchDogIsReset())
 #else
    if(false)
 #endif
        {
 #ifdef DEBUG
        Msg_WriteText("An watchdog reset has happened\r");
 #endif
        for(i_count = 0; i_count < 20; i_count++)
            {
            Port_WriteBit(PORT_LED1, PORT_HIGH);
            Port_WriteBit(PORT_LED2, PORT_LOW);
            Thread_Delay(25);
            Port_WriteBit(PORT_LED1, PORT_LOW);
            Port_WriteBit(PORT_LED2, PORT_HIGH);
            Thread_Delay(25);
            }
        }
    else
        {
        for(i_count = 0; i_count < 50; i_count++)
            {
            Port_ToggleBit(PORT_LED1);
            Thread_Delay(5);
            }
        }

 #ifdef DEBUG
    ShowTimePeriod();
 #endif


 #ifdef MEGA32
    WatchDogInit(WDT_2_1_S);
 #elif MEGA128
    WatchDogInit(WDT_1_8_S);
 #endif

    i_test_nr = 1;
    WatchDogStart();
    while(1)
        {
 #ifdef DEBUG
        Msg_WriteText("test nr.: ");
        Msg_WriteWord(i_test_nr);
 #endif
        switch(i_test_nr)
            {
//------------------------------------------------
            case 1:
                NormalOperation();
                break;
//------------------------------------------------
            case 2:
 #ifdef MEGA32
                WatchDogSetTime(WDT_16_3_MS);
 #elif MEGA128
                WatchDogSetTime(WDT_14_MS);
 #endif
                for(i_count = 0; i_count < 100; i_count++)
                    VeryShortPeriodFunction();
                WatchDogReset();
 #ifdef MEGA32
                WatchDogSetTime(WDT_2_1_S);
 #elif MEGA128
                WatchDogSetTime(WDT_1_8_S);
 #endif
                break;
//------------------------------------------------
            case 3:
                NormalOperation();
                break;
//------------------------------------------------
            case 4:
 #ifdef MEGA32
                WatchDogSetTime(WDT_0_13_S);
 #elif MEGA128
                WatchDogSetTime(WDT_0_11_S);
 #endif
                for(i_count = 0; i_count < 100; i_count++)
                    {
                    ShortPeriodFunction();
                    ShortPeriodFunction();
                    WatchDogReset();
                    }
 #ifdef MEGA32
                WatchDogSetTime(WDT_2_1_S);
 #elif MEGA128
                WatchDogSetTime(WDT_1_8_S);
 #endif
                break;
//------------------------------------------------
            case 5:
                NormalOperation();
                break;
//------------------------------------------------
            case 6:
                WatchDogStop();
                LongPeriodFunction();
                WatchDogStart();
                break;
//------------------------------------------------
            case 7:
                NormalOperation();
                break;
//------------------------------------------------
            case 8:
// a time out is expected
                for(i_count = 0; i_count < 5; i_count)
                    {
                    Port_WriteBit(PORT_LED1, PORT_HIGH);
                    Port_WriteBit(PORT_LED2, PORT_HIGH);
                    Thread_Delay(25);
                    Port_WriteBit(PORT_LED1, PORT_LOW);
                    Port_WriteBit(PORT_LED2, PORT_LOW);
                    Thread_Delay(25);
                    }
 #ifdef DEBUG
                Msg_WriteText(" -> not ok\r");
 #endif
                break;
//------------------------------------------------
            }
 #ifdef DEBUG
        Msg_WriteText(" -> ok\r");
 #endif
        i_test_nr++;
        Port_ToggleBit(PORT_LED1);
        WatchDogReset();
        }
    }
//------------------------------------------------