;*** WatchDog.asm ***;
;-------------------------------------------------
; Author: Torsten Knorr, create-soft@freenet.de
;*** BUGS ***;
; Maybe you'll find some. Please let me know.
; By the way I am pleased with every kind of feedback.
;-------------------------------------------------
 .def R_SP_LOW     = R6
 .def R_SP_HIGH    = R7
 .def R_PARAM_LOW  = R10
 .def R_PARAM_HIGH = R11
 .def R_TEMP_LOW   = R22
 .def R_TEMP_HIGH  = R23
 .def R_ZP_LOW     = R30
 .def R_ZP_HIGH    = R31
;-------------------------------------------------
 .equ WDTCR  = 0x21 ; Watchdog Timer Control Register
 .equ WDE    = 0x03 ; Watch Dog Enable
 .equ WDTOE  = 0x04 ; Watchdog Change Enable
 .equ WDTPM  = 0x07 ; Watch Dog Timer Prescalar Mask
 .equ MCUCSR = 0x34 ; MCU Control and Status Register
 .equ WDRF   = 0x03 ; Watchdog Reset Flag
;-------------------------------------------------
 .ifdef TagWatchDogInit
 WatchDogInit:

; reset WDT
    wdr

; get 1. parametre = by_prescaler
    movw R_ZP_LOW,   R_PARAM_LOW
    ld   R_TEMP_LOW, Z

; mask lower 3 bits
; Only for the case, the user gives us an invalid parametre
    andi R_TEMP_LOW,  WDTPM

; set WDTOE and WDE bit in register
    ldi  R_TEMP_HIGH, (1 << WDTOE) | (1 << WDE)

; enable watchdog change
    out  WDTCR,       R_TEMP_HIGH

; set new prescaler and disable WDT
    out  WDTCR,       R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogSetTime
 WatchDogSetTime:

; reset WDT
    wdr

; get 1. parametre = by_prescaler
    movw R_ZP_LOW,   R_PARAM_LOW
    ld   R_TEMP_LOW, Z

; mask lower 3 bits
; only for the case, the user gives us an invalid parametre
    andi R_TEMP_LOW,  WDTPM

; load WDTCR content in general purpose register
    wdr
    in   R_TEMP_HIGH, WDTCR

; clear the prescaler bits in register
    andi R_TEMP_HIGH, ~WDTPM

; set the new prescaler bits in register
    or   R_TEMP_HIGH, R_TEMP_LOW

; set WDTOE and WDE bit in register
    ldi  R_TEMP_LOW, (1 << WDTOE) | (1 << WDE)

; enable WDT change
    out  WDTCR,       R_TEMP_LOW

; set new prescaler and the old state of WDE bit
    out  WDTCR,       R_TEMP_HIGH

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogStart
 WatchDogStart:

; reset WDT
    wdr

; load WDTCR content in general purpose register
    in  R_TEMP_LOW, WDTCR

; set WDT enable bit
    ori R_TEMP_LOW, (1 << WDE)

; start WDT
    out WDTCR,      R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogStop
 WatchDogStop:

; reset WDT
    wdr

; load old WDTCR content in general purpose registrer
   in   R_TEMP_LOW,  WDTCR

; clear WDT enable bit
   andi R_TEMP_LOW,  ~(1 << WDE)

; set WDTOE and WDE bit in register
    ldi  R_TEMP_HIGH, (1 << WDTOE) | (1 << WDE)

; enable WDT change
    out  WDTCR,       R_TEMP_HIGH

; Turn off WDT
    out  WDTCR,       R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogReset
 WatchDogReset:

; reset WDT
    wdr

    ret
 .endif
;-------------------------------------------------
;*** ToDo ***;
; It doesn't work properly on Mega32!
 .ifdef TagWatchDogIsReset
 WatchDogIsReset:

; load the content of the MCUCSR
    in   R_TEMP_LOW, MCUCSR

; extract the WDRF
    andi R_TEMP_LOW, (1 << WDRF)

; copy stack pointer
     movw R_ZP_LOW, R_SP_LOW

; add 4 to sp
    adiw R_ZP_LOW,   0x04

; copy back to stack pointer location
    movw R_SP_LOW,   R_ZP_LOW

; store byte value on stack
    st   Z+,         R_TEMP_LOW

; only for the case, the user stores the value in a bigger data type
    clr  R_TEMP_LOW
    st   Z+,         R_TEMP_LOW
    st   Z+,         R_TEMP_LOW
    st   Z,          R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------