;*** ADCapture.asm ***;
;-------------------------------------------------
; Author: Torsten Knorr, create-soft@freenet.de
;*** BUGS ***;
; Maybe you'll find some. Please let me know.
; By the way I am pleased with every kind of feedback.
;-------------------------------------------------
;*** Register Definitions ***;
 .def R_DATA_LOW   = R0
 .def R_DATA_HIGH  = R1
 .def R_SP_LOW     = R6
 .def R_SP_HIGH    = R7
 .def R_PARAM_LOW  = R10
 .def R_PARAM_HIGH = R11
 .def R_TEMP_LOW   = R22
 .def R_TEMP_HIGH  = R23
 .def R_COUNT_LOW  = R24
 .def R_COUNT_HIGH = R25
 .def R_XP_LOW     = R26
 .def R_XP_HIGH    = R27
 .def R_ZP_LOW     = R30
 .def R_ZP_HIGH    = R31
;-------------------------------------------------
;*** ADMUX - ADC Multiplexer Selection Register ***;
 .equ ADMUX = 0x07
 .equ MUX0  = 0    ; Analog Channel and Gain Selection Bits
 .equ MUX1  = 1    ; Analog Channel and Gain Selection Bits
 .equ MUX2  = 2    ; Analog Channel and Gain Selection Bits
 .equ MUX3  = 3    ; Analog Channel and Gain Selection Bits
 .equ MUX4  = 4    ; Analog Channel and Gain Selection Bits
 .equ MUXM  = 0x1F ; Analog Channel and Gain Selection Mask
 .equ ADLAR = 5	   ; Left Adjust Result
 .equ REFS0 = 6	   ; Reference Selection Bit 0
 .equ REFS1 = 7    ; Reference Selection Bit 1
;-------------------------------------------------
;*** ADCSRA - ADC Control and Status Register A ***;
 .equ ADCSRA = 0x06
 .equ ADCSR  = ADCSRA ; For compatibility
 .equ ADPS0  = 0      ; ADC Prescaler Select Bits
 .equ ADPS1  = 1      ; ADC Prescaler Select Bits
 .equ ADPS2  = 2      ; ADC Prescaler Select Bits
 .equ ADIE   = 3      ; ADC Interrupt Enable
 .equ ADIF   = 4      ; ADC Interrupt Flag
 .equ ADFR   = 5      ; ADC  Free Running Select
 .equ ADSC   = 6      ; ADC Start Conversion
 .equ ADEN   = 7      ; ADC Enable
;-------------------------------------------------
;*** ADCH - ADC Data Register High Byte ***;
 .equ ADCH  = 0x05
;-------------------------------------------------
;*** ADCL - ADC Data Register Low Byte ***;
 .equ ADCL  = 0x04
;-------------------------------------------------
;*** SREG - Status Register ***;
 .equ SREG  = 0x3F
;-------------------------------------------------
;*** MCUCR - MCU Control Register ***;
 .equ MCUCR = 0x35;
;-------------------------------------------------
 .ifdef TagADCaptureSetDeviceMega32

 .equ SM0   = 4 ; Sleep Mode Select
 .equ SM1   = 5 ; Sleep Mode Select
 .equ SM2   = 6 ; Sleep Mode Select
 .equ SE    = 7 ; Sleep Enable

 ADCaptureSetDevice:

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureSetDeviceMega128

 .equ SM2   = 2    ; Sleep Mode Select
 .equ SM0   = 3    ; Sleep Mode Select
 .equ SM1   = 4    ; Sleep Mode Select
 .equ SE    = 5    ; Sleep Enable

 ADCaptureSetDevice:

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureSetVref
 ADCaptureSetVref:

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 1st parameter (by_vref) into R_TEMP_LOW
    ld    R_TEMP_LOW,    Z

; mask bits REFS0/REFS1
    andi  R_TEMP_LOW,    (1 << REFS0)|(1 << REFS1)

    in    R_TEMP_HIGH,   ADMUX
    cbr   R_TEMP_HIGH,   (1 << REFS0)|(1 << REFS1)
    or    R_TEMP_HIGH,   R_TEMP_LOW

    out   ADMUX,         R_TEMP_HIGH

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureSetPrescaler
 ADCaptureSetPrescaler:

; move parameter stack pointer into Z
    movw R_ZP_LOW,     R_PARAM_LOW

; load 1st parameter (by_prescaler) into R_TEMP_LOW
    ld   R_TEMP_LOW,   Z

; mask bits ADPS0/ADPS1/ADPS2
    andi  R_TEMP_LOW,    (1 << ADPS0)|(1 << ADPS1)|(1 << ADPS2)

    in    R_TEMP_HIGH,   ADCSRA
    cbr   R_TEMP_HIGH,   (1 << ADPS0)|(1 << ADPS1)|(1 << ADPS2)
    or    R_TEMP_HIGH,   R_TEMP_LOW

    out   ADCSRA,        R_TEMP_HIGH

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureSetChannel
 ADCaptureSetChannel:

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 1st parameter (by_channel) into R_TEMP_LOW
    ld    R_TEMP_LOW,    Z

; mask bits MUX0/MUX1/MUX2/MUX3/MUX4
    andi  R_TEMP_LOW,    MUXM

    in    R_TEMP_HIGH,   ADMUX
    cbr   R_TEMP_HIGH,   MUXM
    or    R_TEMP_HIGH,   R_TEMP_LOW

    out   ADMUX,         R_TEMP_HIGH

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRun
 ADCaptureRun:

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (w_buffer_size) into R_COUNT
    ld    R_COUNT_LOW,   Z+
    ld    R_COUNT_HIGH,  Z+

; load 1st parameter (p_buffer) into X
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

; clear Free Running mode
    cbi   ADCSRA,        ADFR

; clear ADC interrupt flag
    cbi   ADCSRA,        ADIE

; set ADC Enable
    sbi   ADCSRA,        ADEN

 AD_CAPTURE_RUN_LOOP:

; set Start Conversion
    sbi   ADCSRA,        ADSC

 AD_CAPTURE_RUN_WAIT:
    sbic  ADCSRA,        ADSC
    rjmp  AD_CAPTURE_RUN_WAIT

; load ADC value in R_TEMP
    in    R_TEMP_LOW,    ADCL
    in    R_TEMP_HIGH,   ADCH

; store the values in the word array
    st    X+,            R_TEMP_LOW
    st    X+,            R_TEMP_HIGH

; repeat ADC loop if R_COUNT is not zero
    sbiw  R_COUNT_LOW,   1
    brne  AD_CAPTURE_RUN_LOOP

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRunFree
 ADCaptureRunFree:

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (w_buffer_size) into R_COUNT
    ld    R_COUNT_LOW,   Z+
    ld    R_COUNT_HIGH,  Z+

; load 1st parameter (p_buffer) into X
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

    in    R_DATA_LOW,    SREG
; clear global interrupt flag
    cli

; set Free Running mode
    sbi   ADCSRA,        ADFR

; set ADC Enable
    sbi   ADCSRA,        ADEN

; set Start Conversion
    sbi   ADCSRA,        ADSC

 AD_CAPTURE_RUN_FREE_LOOP:

 AD_CAPTURE_RUN_FREE_WAIT:
    sbis  ADCSRA,        ADIF
    rjmp  AD_CAPTURE_RUN_FREE_WAIT

; clear ADC interrupt flag
    sbi   ADCSRA,        ADIF

; load ADC value in R_TEMP
    in    R_TEMP_LOW,    ADCL
    in    R_TEMP_HIGH,   ADCH

; store the value in the word array
    st    X+,            R_TEMP_LOW
    st    X+,            R_TEMP_HIGH

; repeat ADC loop if R_COUNT is not zero
    sbiw  R_COUNT_LOW,   1
    brne  AD_CAPTURE_RUN_FREE_LOOP

; restore status register
    out   SREG,          R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRunQuiet
 ADCaptureRunQuiet:

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (w_buffer_size) into R_COUNT
    ld    R_COUNT_LOW,   Z+
    ld    R_COUNT_HIGH,  Z+

; load 1st parameter (p_buffer) into X
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

    in    R_DATA_LOW,    SREG
    sei

; clear Free Running mode
    cbi   ADCSRA,        ADFR

; set ADC Enable
    sbi   ADCSRA,        ADEN

; enable sleep mode
    in    R_DATA_HIGH,   MCUCR
    mov   R_ZP_LOW,      R_DATA_HIGH
    cbr   R_ZP_LOW,      (1 << SM1)|(1 << SM2)
    sbr   R_ZP_LOW,      (1 << SE)|(1 << SM0)
    out   MCUCR,         R_ZP_LOW

; an empty measurement for initialization
; set Start Conversion
    sbi   ADCSRA,        ADSC

 AD_CAPTURE_RUN_QUIET_WAIT:
    sbic  ADCSRA,        ADSC
    rjmp  AD_CAPTURE_RUN_QUIET_WAIT

; set ADC Interrupt Enable
    sbi   ADCSRA,        ADIE

 AD_CAPTURE_RUN_QUIET_LOOP:

; Enter ADC Noise Reduction mode.
    sleep

; load ADC value in R_TEMP
    in    R_TEMP_LOW,    ADCL
    in    R_TEMP_HIGH,   ADCH

; store the value in the word array
    st    X+,            R_TEMP_LOW
    st    X+,            R_TEMP_HIGH

; repeat ADC loop if R_COUNT is not zero
    sbiw  R_COUNT_LOW,   1
    brne  AD_CAPTURE_RUN_QUIET_LOOP

; restore MCU Control Register
    out   MCUCR,         R_DATA_HIGH

; restore status register
    out   SREG,          R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRunFreeFloat
 ADCaptureRunFreeFloat:

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (w_buffer_size) into R_COUNT
    ld    R_COUNT_LOW,   Z+
    ld    R_COUNT_HIGH,  Z+

; load 1st parameter (p_buffer) into X
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

    in    R_DATA_LOW,    SREG
; clear global interrupt flag
    cli

; set Free Running mode
    sbi   ADCSRA,        ADFR

; set ADC Enable
    sbi   ADCSRA,        ADEN

; set Start Conversion
    sbi   ADCSRA,        ADSC

 AD_CAPTURE_RUN_FREE_FLOAT_LOOP:

 AD_CAPTURE_RUN_FREE_FLOAT_WAIT:
    sbis  ADCSRA,        ADIF
    rjmp  AD_CAPTURE_RUN_FREE_FLOAT_WAIT

; clear ADC interrupt flag
    sbi   ADCSRA,        ADIF

; load ADC value in R_TEMP
    in    R_TEMP_LOW,    ADCL
    in    R_TEMP_HIGH,   ADCH

; Conversion of 12 bit ADC value (in 16 bit register) to 32 bit float.
; The 32 bits float consists of:
; 1  bit  sign
; 8  bits exponent
; 23 bits mantisse
; The ADC value sign is always positive therefore is the sign = 0.
; bias = 127
; max. loops = 16
; 0x10|16 + 0x7F|127 = 0x8F|143
; set starting value of the exponent to 143
    ldi   R_ZP_LOW,      0x8F

; set max loops
    ldi   R_ZP_HIGH,     0x10

 AD_CAPTURE_FIND_EXPONENT:

; decrease exponent with 1
    dec   R_ZP_LOW

; shift left low byte of ADC value
    lsl   R_TEMP_LOW

; rotate left high byte of ADC value
    rol   R_TEMP_HIGH

; branch if carry set
    brcs  AD_CAPTURE_EXPONENT_FOUND

    dec   R_ZP_HIGH
    brne  AD_CAPTURE_FIND_EXPONENT

; in the case the value is zero
    clr   R_ZP_LOW
    rjmp  AD_CAPTURE_STORE_VALUE

 AD_CAPTURE_EXPONENT_FOUND:
    lsr   R_ZP_LOW
    ror   R_TEMP_HIGH
    ror   R_TEMP_LOW

; store the value in the float array
 AD_CAPTURE_STORE_VALUE:
    clr   R_DATA_HIGH
    st    X+,            R_DATA_HIGH
    st    X+,            R_TEMP_LOW
    st    X+,            R_TEMP_HIGH
    st    X+,            R_ZP_LOW

; repeat ADC loop if R_COUNT is not zero
    sbiw  R_COUNT_LOW,   1
    brne  AD_CAPTURE_RUN_FREE_FLOAT_LOOP

; restore status register
    out   SREG,          R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureNoiseReduction
 ADCaptureNoiseReduction:

    in    R_DATA_LOW,    SREG
    sei

; clear Free Running mode
    cbi   ADCSRA,        ADFR

; set ADC Enable
    sbi   ADCSRA,        ADEN

; enable sleep mode
    in    R_DATA_HIGH,   MCUCR
    mov   R_ZP_LOW,      R_DATA_HIGH
    cbr   R_ZP_LOW,      (1 << SM1)|(1 << SM2)
    sbr   R_ZP_LOW,      (1 << SE)|(1 << SM0)
    out   MCUCR,         R_ZP_LOW

; an empty measurement for initialization
; set Start Conversion
    ;sbi   ADCSRA,        ADSC

 ;AD_CAPTURE_SLEEP_WAIT:
    ;sbic  ADCSRA,        ADSC
    ;rjmp  AD_CAPTURE_SLEEP_WAIT

; set ADC Interrupt Enable
    sbi   ADCSRA,        ADIE

; Enter ADC Noise Reduction mode.
    sleep

; clear ADC Interrupt Enable
    cbi  ADCSRA,       ADIE

; clear ADC Enable
    cbi  ADCSRA,       ADEN

; restore MCU Control Register
    out   MCUCR,         R_DATA_HIGH

; restore status register
    out   SREG,          R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureSmooth
 ADCaptureSmooth:

; move parameter stack pointer into X
    movw  R_XP_LOW,      R_PARAM_LOW

; load 2nd parameter (w_buffer_size) into R_COUNT
    ld    R_COUNT_LOW,   X+
    ld    R_COUNT_HIGH,  X+

; load 1st parameter (p_buffer) into X
    ld    R_ZP_LOW,      X+
    ld    R_ZP_HIGH,     X

    sbiw  R_COUNT_LOW,   3

 AD_CAPTURE_SMOOTH_LOOP:

    ld    R_TEMP_LOW,    Z
    ldd   R_TEMP_HIGH,   Z+1

    ldd   R_DATA_LOW,    Z+2
    ldd   R_DATA_HIGH,   Z+3

    add   R_TEMP_LOW,    R_DATA_LOW
    adc   R_TEMP_HIGH,   R_DATA_HIGH

    ldd   R_DATA_LOW,    Z+4
    ldd   R_DATA_HIGH,   Z+5

    add   R_TEMP_LOW,    R_DATA_LOW
    adc   R_TEMP_HIGH,   R_DATA_HIGH

    ldd   R_DATA_LOW,    Z+6
    ldd   R_DATA_HIGH,   Z+7

    add   R_TEMP_LOW,    R_DATA_LOW
    adc   R_TEMP_HIGH,   R_DATA_HIGH

    lsr   R_TEMP_HIGH
    ror   R_TEMP_LOW

    lsr   R_TEMP_HIGH
    ror   R_TEMP_LOW

    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_HIGH

; repeat loop if R_COUNT is not zero
    sbiw  R_COUNT_LOW,   1
    brne  AD_CAPTURE_SMOOTH_LOOP

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRelease
 ADCaptureRelease:

; clear ADC Enable
    cbi  ADCSRA,       ADEN

; clear ADC Interrupt Enable
    cbi  ADCSRA,       ADIE

    ret
 .endif
;-------------------------------------------------