/*** RelayCardRS232.cc ***/
//------------------------------------------------
 #include "RelayCard.h"
//------------------------------------------------
 byte gaby_serial_port_buffer[SERIAL_BUFF_SIZE];
 byte gaby_tx_buffer[FRAME_SIZE] = {0, 0, 0, 0};
 word gaw_rx_buffer[FRAME_SIZE * (RELAY_CARDS_COUNT + 1)] = {0, 0, 0, 0};
 byte gby_item;
 BOOL gbo_result;
 BOOL gbo_send;
//------------------------------------------------
 BOOL RelayCardRS232Init(void)
    {
    int i_index;
    word w_response;

// Initialisiere Schnittstelle mit 19200baud, 8 Bit, 1 Stop Bit, keine Paritt
    Serial_Init_IRQ(
        SERIAL_PORT,
        gaby_serial_port_buffer,
        RECEIVE_BUFF_SIZE,
        TRANSMIT_BUFF_SIZE,
        SR_8BIT|SR_1STOP|SR_NO_PAR,
        SR_BD19200
        );

    RelayCardRS232ClearBuffer();

    gaby_tx_buffer[COMMAND]  = SETUP;
    gaby_tx_buffer[ADDRESS]  = CARD_1;
    gaby_tx_buffer[DATA]     = 0x00;
    gaby_tx_buffer[CHECKSUM] = RelayCardChecksum();

    return RelayCardRS232Send(FRAME_SIZE * (RELAY_CARDS_COUNT + 1));
    }
//------------------------------------------------
 void RelayCardRS232ClearBuffer(void)
    {

    Serial_Write(SERIAL_PORT, 0x00);
    Serial_Write(SERIAL_PORT, 0x00);
    Serial_Write(SERIAL_PORT, 0x00);
    Serial_Write(SERIAL_PORT, 0x00);

    Thread_Delay(RELAY_CARDS_COUNT);

    while(0x100 != Serial_ReadExt(SERIAL_PORT));

    }
//------------------------------------------------
 BOOL RelayCardRS232Send(word w_bytes_to_receive)
    {
    int i_index;
    word w_response;

    for(i_index = 0; i_index < FRAME_SIZE; i_index++)
        Serial_Write(SERIAL_PORT, gaby_tx_buffer[i_index]);

    Thread_Delay(RELAY_CARDS_COUNT);

    for(i_index = 0; i_index < w_bytes_to_receive; i_index++)
        {
        w_response = Serial_ReadExt(SERIAL_PORT);
        if(0x100 == w_response)
            return false;
        gaw_rx_buffer[i_index] = w_response;
        }

    gbo_result = RelayCardRS232CheckResponse(i_index / 4);

    return gbo_result;
    }
//------------------------------------------------
 BOOL RelayCardRS232CheckResponse(byte by_received_frames)
    {
    byte by_frame_number;
    byte by_offset;

    for(by_frame_number = 0; by_frame_number < by_received_frames; by_frame_number++)
        {
        by_offset = 4 * by_frame_number;
        if(!(gaw_rx_buffer[CHECKSUM + by_offset] ==
            (gaw_rx_buffer[COMMAND  + by_offset] ^
             gaw_rx_buffer[ADDRESS  + by_offset] ^
             gaw_rx_buffer[DATA     + by_offset])))
                {
                gbo_result = false;
                return false;
                }

        switch(gaby_tx_buffer[COMMAND])
            {
            case NO_OPERATION:
                if( (NO_OPERATION_OK == gaw_rx_buffer[by_offset])
                    ||
                    (NO_OPERATION    == gaw_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case SETUP:
                if( (SETUP_OK        == gaw_rx_buffer[by_offset])
                    ||
                    (SETUP           == gaw_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case GET_PORT:
                if( (GET_PORT_OK     == gaw_rx_buffer[by_offset])
                    ||
                    (GET_PORT        == gaw_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case SET_PORT:
                if( (SET_PORT_OK     == gaw_rx_buffer[by_offset])
                    ||
                    (SET_PORT        == gaw_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case GET_OPTION:
                if( (GET_OPTION_OK   == gaw_rx_buffer[by_offset])
                    ||
                    (GET_OPTION      == gaw_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case SET_OPTION:
                if( (SET_OPTION_OK   == gaw_rx_buffer[by_offset])
                    ||
                    (SET_OPTION      == gaw_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case SET_SINGLE:
                if( (SET_SINGLE_OK   == gaw_rx_buffer[by_offset])
                    ||
                    (SET_SINGLE      == gaw_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case DEL_SINGLE:
                if( (DEL_SINGLE_OK   == gaw_rx_buffer[by_offset])
                    ||
                    (DEL_SINGLE      == gaw_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case TOGGLE:
                if( (TOGGLE_OK       == gaw_rx_buffer[by_offset])
                    ||
                    (TOGGLE          == gaw_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            default:
                gbo_result = false;
                return false;
            }
        }

    gbo_result = true;
    return true;
    }
//------------------------------------------------
 void RelayCardRS232ShowFrames(word w_rx_buffer_size)
    {
    char ac_msg[10];
    word w_count;

    Msg_WriteText("Send:");
    for(w_count = 0; w_count < FRAME_SIZE; w_count++)
        {
        if(!(w_count % 4))
            Msg_WriteChar(13);
        Str_Printf(ac_msg, "0x%02x ", gaby_tx_buffer[w_count]);
        Msg_WriteText(ac_msg);
        }
    Msg_WriteChar(13);

    Msg_WriteText("Receive:");
    for(w_count = 0; w_count < w_rx_buffer_size; w_count++)
        {
        if(!(w_count % 4))
            Msg_WriteChar(13);
        Str_Printf(ac_msg, "0x%02x ", gaw_rx_buffer[w_count]);
        Msg_WriteText(ac_msg);
        }
    Msg_WriteChar(13);
    }
//------------------------------------------------