;*** IRControl.asm ***;
;-------------------------------------------------
 .ifdef TagIRControlStart

 IRControlStart:

; Set TCCR1A - Timer/Counter1 Control Register A.
    clr   R_TEMP_LOW
    out   TCCR1A,        R_TEMP_LOW

; Set TCCR1B - Timer/Counter1 Control Register B.
; ICNC1 = Input Capture Noise Canceler
; ICES1 = Input Capture Edge Select
; ICES1 = 0 -> a falling (negative) edge is used as trigger
; ICES1 = 1 -> a rising (positive) edge will trigger the capture
; Clock Select Bit Description
; CS12 CS11 CS10 Description
; 0    1    0    clk / 8
    ldi   R_TEMP_LOW,    (1 << ICNC1) | (1 << CS11)
    out   TCCR1B,        R_TEMP_LOW

    ldi   R_TEMP_LOW,    (1 << TOV1) | (1 << ICF1)
    out   TIFR,          R_TEMP_LOW

; TIMSK - Timer/Counter Interrupt Mask Register
    in    R_TEMP_LOW,    TIMSK
    sbr   R_TEMP_LOW,    (1 << TICIE1)
    out   TIMSK,         R_TEMP_LOW

; Set global interrupt flag.
    sei
    ret
 .endif
;-------------------------------------------------
 .ifdef TagIRControlStart128Can

 IRControlStart:

    clr   R_TEMP_LOW
    sts   TCCR1A,        R_TEMP_LOW

; Set TCCR1B : Timer/Counter 1 Control Register B
    ldi   R_TEMP_LOW,    (1 << ICNC1) | (1 << CS11)
    sts   TCCR1B,        R_TEMP_LOW

    ldi   R_TEMP_LOW,    (1 << TOV1) | (1 << ICF1)
    out   TIFR1,         R_TEMP_LOW

; TIMSK1 - Timer/Counter Interrupt Mask Register
    lds   R_TEMP_LOW,    TIMSK1
    sbr   R_TEMP_LOW,    (1 << ICIE1)
    sts   TIMSK1,         R_TEMP_LOW

; Set global interrupt flag.
    sei
    ret
 .endif
;-------------------------------------------------
 .ifdef TagIRControlCapture

 IRControlCapture:

; Save global interrupt flag
    in    R_DATA_Low,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (by_bits_to_read) into R_COUNT_LOW
    ld    R_COUNT_LOW,   Z+

; load 1st parameter (p_buffer) into R_XP
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

    clr   R_DATA_HIGH
    out   TCNT1H,        R_DATA_HIGH
    out   TCNT1L,        R_DATA_HIGH

    ldi   R_COUNT_HIGH,  (1 << TOV1)
    out   TIFR,          R_COUNT_HIGH
    ldi   R_COUNT_HIGH,  (1 << ICF1)
    out   TIFR,          R_COUNT_HIGH

 IR_CONTROL_CAPTURE_LOOP:

; ICES1 = 1 -> a rising (positive) edge will trigger the capture
    in    R_TEMP_LOW,    TCCR1B
    sbr   R_TEMP_LOW,    (1 << ICES1)
    out   TCCR1B,        R_TEMP_LOW

 IR_CONTROL_CAPTURE_WAIT_1:
    in    R_TEMP_LOW,    TIFR
    sbrc  R_TEMP_LOW,    TOV1
    rjmp  IR_CONTROL_CAPTURE_TIMEOUT
    sbrs  R_TEMP_LOW,    ICF1
    rjmp  IR_CONTROL_CAPTURE_WAIT_1
    out   TIFR,          R_COUNT_HIGH

    out   TCNT1H,        R_DATA_HIGH
    out   TCNT1L,        R_DATA_HIGH

; ICES1 = 0 -> a falling (negative) edge will trigger the capture
    in    R_TEMP_LOW,    TCCR1B
    cbr   R_TEMP_LOW,    (1 << ICES1)
    out   TCCR1B,        R_TEMP_LOW

 IR_CONTROL_CAPTURE_WAIT_2:
    in    R_TEMP_LOW,    TIFR
    sbrc  R_TEMP_LOW,    TOV1
    rjmp  IR_CONTROL_CAPTURE_TIMEOUT
    sbrs  R_TEMP_LOW,    ICF1
    rjmp  IR_CONTROL_CAPTURE_WAIT_2
    out   TIFR,          R_COUNT_HIGH

    in    R_TEMP_LOW,    ICR1L
    in    R_TEMP_HIGH,   ICR1H
    st    X+,            R_TEMP_LOW
    st    X+,            R_TEMP_HIGH

    dec   R_COUNT_LOW
    brne  IR_CONTROL_CAPTURE_LOOP

; Timer 1 stop
    clr   R_TEMP_LOW
    out   TCCR1B,        R_TEMP_LOW

; Disable Interrupt
; ETIMSK - Extended Timer/Counter Interrupt Mask Register
    in    R_TEMP_LOW,    TIMSK
    cbr   R_TEMP_LOW,    (1 << TICIE1)
    out   TIMSK,         R_TEMP_LOW

; Return success ture
    ldi   R_TEMP_LOW,    0x01
    rjmp  IR_CONTROL_CAPTURE_RETURN

 IR_CONTROL_CAPTURE_TIMEOUT:

; ICES1 = 0 -> a falling (negative) edge will trigger the capture
; At a time-out we must leave the function with this status.
    in    R_TEMP_LOW,    TCCR1B
    cbr   R_TEMP_LOW,    (1 << ICES1)
    out   TCCR1B,        R_TEMP_LOW

    ldi   R_TEMP_LOW,    (1 << ICF1) | (1 << TOV1)
    out   TIFR,          R_TEMP_LOW

; Return error false
    clr   R_TEMP_LOW

 IR_CONTROL_CAPTURE_RETURN:

; copy stack pointer
    movw  R_ZP_LOW,      R_SP_LOW

; add 4 to sp
    adiw  R_ZP_LOW,      0x04

; copy back to stack pointer location
    movw  R_SP_LOW,      R_ZP_LOW

; store values on stack
    st    Z+,            R_TEMP_LOW
    clr   R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z,             R_TEMP_LOW

; Restore global interrupt flag
    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagIRControlCapture128Can
 IRControlCapture:

; Save global interrupt flag
    in    R_DATA_Low,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (by_bits_to_read) into R_COUNT_LOW
    ld    R_COUNT_LOW,   Z+

; load 1st parameter (p_buffer) into R_XP
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

    clr   R_DATA_HIGH
    sts   TCNT1H,        R_DATA_HIGH
    sts   TCNT1L,        R_DATA_HIGH

    ldi   R_COUNT_HIGH,  (1 << TOV1)
    out   TIFR1,         R_COUNT_HIGH
    ldi   R_COUNT_HIGH,  (1 << ICF1)
    out   TIFR1,         R_COUNT_HIGH

 IR_CONTROL_CAPTURE_LOOP_CAN:

; ICES1 = 1 -> a rising (positive) edge will trigger the capture
    lds   R_TEMP_LOW,    TCCR1B
    sbr   R_TEMP_LOW,    (1 << ICES1)
    sts   TCCR1B,        R_TEMP_LOW

 IR_CONTROL_CAPTURE_WAIT_CAN_1:
    in    R_TEMP_LOW,    TIFR1
    sbrc  R_TEMP_LOW,    TOV1
    rjmp  IR_CONTROL_CAPTURE_TIMEOUT_CAN
    sbrs  R_TEMP_LOW,    ICF1
    rjmp  IR_CONTROL_CAPTURE_WAIT_CAN_1
    out   TIFR1,         R_COUNT_HIGH

    sts   TCNT1H,        R_DATA_HIGH
    sts   TCNT1L,        R_DATA_HIGH

; ICES1 = 0 -> a falling (negative) edge will trigger the capture
    lds   R_TEMP_LOW,    TCCR1B
    cbr   R_TEMP_LOW,    (1 << ICES1)
    sts   TCCR1B,        R_TEMP_LOW

 IR_CONTROL_CAPTURE_WAIT_CAN_2:
    in    R_TEMP_LOW,    TIFR1
    sbrc  R_TEMP_LOW,    TOV1
    rjmp  IR_CONTROL_CAPTURE_TIMEOUT_CAN
    sbrs  R_TEMP_LOW,    ICF1
    rjmp  IR_CONTROL_CAPTURE_WAIT_CAN_2
    out   TIFR1,         R_COUNT_HIGH

    lds   R_TEMP_LOW,    ICR1L
    lds   R_TEMP_HIGH,   ICR1H
    st    X+,            R_TEMP_LOW
    st    X+,            R_TEMP_HIGH

    dec   R_COUNT_LOW
    brne  IR_CONTROL_CAPTURE_LOOP_CAN

; Timer 1 stop
    clr   R_TEMP_LOW
    sts   TCCR1B,        R_TEMP_LOW

; Disable Interrupt
; ETIMSK - Extended Timer/Counter Interrupt Mask Register
    lds   R_TEMP_LOW,    TIMSK1
    cbr   R_TEMP_LOW,    (1 << ICIE1)
    sts   TIMSK1,        R_TEMP_LOW

; Return success ture
    ldi   R_TEMP_LOW,    0x01
    rjmp  IR_CONTROL_CAPTURE_RETURN_CAN

 IR_CONTROL_CAPTURE_TIMEOUT_CAN:

; ICES1 = 0 -> a falling (negative) edge will trigger the capture
; At a time-out we must leave the function with this status.
    lds   R_TEMP_LOW,    TCCR1B
    cbr   R_TEMP_LOW,    (1 << ICES1)
    sts   TCCR1B,        R_TEMP_LOW

    ldi   R_TEMP_LOW,    (1 << ICF1) | (1 << TOV1)
    out   TIFR1,         R_TEMP_LOW

; Return error false
    clr   R_TEMP_LOW

 IR_CONTROL_CAPTURE_RETURN_CAN:

; copy stack pointer
    movw  R_ZP_LOW,      R_SP_LOW

; add 4 to sp
    adiw  R_ZP_LOW,      0x04

; copy back to stack pointer location
    movw  R_SP_LOW,      R_ZP_LOW

; store values on stack
    st    Z+,            R_TEMP_LOW
    clr   R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z,             R_TEMP_LOW

; Restore global interrupt flag
    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagIRControlStop

 IRControlStop:

    clr   R_TEMP_LOW
    out   TCCR1B,        R_TEMP_LOW

; ETIMSK - Extended Timer/Counter Interrupt Mask Register
    in    R_TEMP_LOW,    TIMSK
    cbr   R_TEMP_LOW,    (1 << TICIE1)
    out   TIMSK,         R_TEMP_LOW

    ldi   R_TEMP_LOW,    (1 << TOV1) | (1 << ICF1)
    out   TIFR,          R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagIRControlStopCan
 IRControlStop:

    clr   R_TEMP_LOW
    sts   TCCR1B,        R_TEMP_LOW

; ETIMSK - Extended Timer/Counter Interrupt Mask Register
    lds   R_TEMP_LOW,    TIMSK1
    cbr   R_TEMP_LOW,    (1 << ICIE1)
    sts   TIMSK1,        R_TEMP_LOW

    ldi   R_TEMP_LOW,    (1 << TOV1) | (1 << ICF1)
    out   TIFR1,         R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagIRControlCaptureV2_32

 IRControlCaptureV2:

; Save global interrupt flag
    in    R_DATA_Low,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (by_bits_to_read) into R_COUNT_LOW
    ld    R_DATA_HIGH,   Z+

; load 1st parameter (p_buffer) into R_XP
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

    ldi   R_TEMP_HIGH,   (1 << INTF2)

 IR_CONTROL_CAPTURE_V2_32_LOOP:

; ISC2 = 1 -> a rising (positive) edge will trigger the interrupt
    in    R_TEMP_LOW,    MCUCSR
    sbr   R_TEMP_LOW,    (1 << ISC2)
    out   MCUCSR,        R_TEMP_LOW

    clr   R_COUNT_LOW
    clr   R_COUNT_HIGH
 IR_CONTROL_CAPTURE_WAIT_V2_1_32:
    adiw  R_COUNT_LOW,   1
    breq  IR_CONTROL_CAPTURE_TIMEOUT_V2_32
    in    R_TEMP_LOW,    GIFR
    sbrs  R_TEMP_LOW,    INTF2
    rjmp  IR_CONTROL_CAPTURE_WAIT_V2_1_32
    out   GIFR,          R_TEMP_HIGH

; ISC2 = 0 -> a falling (negative) edge will trigger the interrupt
    in    R_TEMP_LOW,    MCUCSR
    cbr   R_TEMP_LOW,    (1 << ISC2)
    out   MCUCSR,        R_TEMP_LOW

    clr   R_COUNT_LOW
    clr   R_COUNT_HIGH
 IR_CONTROL_CAPTURE_WAIT_V2_2_32:
    adiw  R_COUNT_LOW,   1
    breq  IR_CONTROL_CAPTURE_TIMEOUT_V2_32
    in    R_TEMP_LOW,    GIFR
    sbrs  R_TEMP_LOW,    INTF2
    rjmp  IR_CONTROL_CAPTURE_WAIT_V2_2_32
    out   GIFR,          R_TEMP_HIGH

    st    X+,            R_COUNT_LOW
    st    X+,            R_COUNT_HIGH

    dec   R_DATA_HIGH
    brne  IR_CONTROL_CAPTURE_V2_32_LOOP

; disable extern interrupt
    in    R_TEMP_LOW,    GICR
    cbr   R_TEMP_LOW,    (1 << INT2)
    out   GICR,          R_TEMP_LOW

; Return success ture
    ldi   R_TEMP_LOW,    0x01
    rjmp  IR_CONTROL_CAPTURE_RETURN_V2_32

 IR_CONTROL_CAPTURE_TIMEOUT_V2_32:

; ISC2 = 0 -> a falling (negative) edge will trigger the interrupt
; At a time-out we must leave the function with this status.
    in    R_TEMP_HIGH,   MCUCSR
    cbr   R_TEMP_HIGH,   (1 << ISC2)
    out   MCUCSR,        R_TEMP_HIGH

    out   GIFR,          R_TEMP_HIGH
    clr   R_TEMP_LOW

 IR_CONTROL_CAPTURE_RETURN_V2_32:

; copy stack pointer
    movw  R_ZP_LOW,      R_SP_LOW

; add 4 to sp
    adiw  R_ZP_LOW,      0x04

; copy back to stack pointer location
    movw  R_SP_LOW,      R_ZP_LOW

; store values on stack
    st    Z+,            R_TEMP_LOW
    clr   R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z,             R_TEMP_LOW

; Restore global interrupt flag
    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagIRControlCaptureV2_128

 IRControlCaptureV2:

; Save global interrupt flag
    in    R_DATA_Low,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (by_bits_to_read) into R_COUNT_LOW
    ld    R_DATA_HIGH,   Z+

; load 1st parameter (p_buffer) into R_XP
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

    ldi   R_TEMP_HIGH,   (1 << INTF2)

 IR_CONTROL_CAPTURE_V2_128_LOOP:

; ISC20/ISC21 = 1 -> a rising (positive) edge will trigger the interrupt
    lds   R_TEMP_LOW,    EICRA
    sbr   R_TEMP_LOW,    (1 << ISC20) | (1 << ISC21)
    sts   EICRA,         R_TEMP_LOW

    clr   R_COUNT_LOW
    clr   R_COUNT_HIGH
 IR_CONTROL_CAPTURE_WAIT_V2_1_128:
    adiw  R_COUNT_LOW,   1
    breq  IR_CONTROL_CAPTURE_TIMEOUT_V2_128
    in    R_TEMP_LOW,    EIFR
    sbrs  R_TEMP_LOW,    INTF2
    rjmp  IR_CONTROL_CAPTURE_WAIT_V2_1_128
    out   EIFR,          R_TEMP_HIGH

; ISC20 = 0 / ISC21 = 1 -> a falling (negative) edge will trigger the interrupt
    lds   R_TEMP_LOW,    EICRA
    cbr   R_TEMP_LOW,    (1 << ISC20)
    ;sbr   R_TEMP_LOW,    (1 << ISC21)
    sts   EICRA,         R_TEMP_LOW

    clr   R_COUNT_LOW
    clr   R_COUNT_HIGH
 IR_CONTROL_CAPTURE_WAIT_V2_2_128:
    adiw  R_COUNT_LOW,   1
    breq  IR_CONTROL_CAPTURE_TIMEOUT_V2_128
    in    R_TEMP_LOW,    EIFR
    sbrs  R_TEMP_LOW,    INTF2
    rjmp  IR_CONTROL_CAPTURE_WAIT_V2_2_128
    out   EIFR,          R_TEMP_HIGH

    st    X+,            R_COUNT_LOW
    st    X+,            R_COUNT_HIGH

    dec   R_DATA_HIGH
    brne  IR_CONTROL_CAPTURE_V2_128_LOOP

; disable extern interrupt
    in    R_TEMP_LOW,    EIMSK
    cbr   R_TEMP_LOW,    (1 << INT2)
    out   EIMSK,          R_TEMP_LOW

; Return success ture
    ldi   R_TEMP_LOW,    0x01
    rjmp  IR_CONTROL_CAPTURE_RETURN_V2_128

 IR_CONTROL_CAPTURE_TIMEOUT_V2_128:
    out   EIFR,          R_TEMP_HIGH
    clr   R_TEMP_LOW

; ISC20 = 0 / ISC21 = 1 -> a falling (negative) edge will trigger the interrupt
; At a time-out we must leave the function with this status.
    lds   R_TEMP_HIGH,   EICRA
    cbr   R_TEMP_HIGH,   (1 << ISC20)
    ;sbr   R_TEMP_HIGH,   (1 << ISC21)
    sts   EICRA,         R_TEMP_HIGH

 IR_CONTROL_CAPTURE_RETURN_V2_128:

; copy stack pointer
    movw  R_ZP_LOW,      R_SP_LOW

; add 4 to sp
    adiw  R_ZP_LOW,      0x04

; copy back to stack pointer location
    movw  R_SP_LOW,      R_ZP_LOW

; store values on stack
    st    Z+,            R_TEMP_LOW
    clr   R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z,             R_TEMP_LOW

; Restore global interrupt flag
    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------