/******************************************************************
Lib zum Ansteuern des DOG 163-Displays auf der Basis von LCD_Lib.cc
07.07.2011 Dr. Michael Heber
*******************************************************************/

/******************************************************************
 LCD Library
*******************************************************************/
void LCD_WriteCTRRegister(byte cmd)
{
    LCD_WriteRegister(cmd,0x00);
}

void LCD_WriteDataRegister(byte x)
{
    LCD_WriteRegister(x,0x01);
}

void LCD_Init(void)
{
    LCD_SubInit();

    LCD_WriteCTRRegister(0x29);
    AbsDelay(10);
    LCD_WriteCTRRegister(0x15);
    AbsDelay(10);
    LCD_WriteCTRRegister(0x50);
    AbsDelay(10);
    LCD_WriteCTRRegister(0x79);
    AbsDelay(10);
    LCD_WriteCTRRegister(0x55);
    AbsDelay(10);
    LCD_WriteCTRRegister(0x6e);
    AbsDelay(10);
    LCD_WriteCTRRegister(0x0f);
    AbsDelay(10);
    LCD_WriteCTRRegister(0x01);
    AbsDelay(10);
    LCD_WriteCTRRegister(0x06);
    AbsDelay(10);
    LCD_TestBusy();
}
//------------------------------------------------------------------------------
// LCD_PutChar
// This function writes one character to the display memory
//------------------------------------------------------------------------------
void LCD_WriteChar(char c)
{
    LCD_WriteDataRegister(c);
}
//------------------------------------------------------------------------------
// Cursor On
// switch cursor on
//------------------------------------------------------------------------------
void LCD_CursorOn(void)
{
    LCD_WriteCTRRegister(0x0f);
}
//------------------------------------------------------------------------------
// Cursor Off
// switch cursor off
//------------------------------------------------------------------------------
void LCD_CursorOff(void)
{
    LCD_WriteCTRRegister(0x0c);
}
//------------------------------------------------------------------------------
// Cursor Pos
// set cursor position. Refer to display specification
//------------------------------------------------------------------------------
void LCD_CursorPos(byte pos)
{
    LCD_WriteCTRRegister(pos|0x80);
}
//------------------------------------------------------------------------------
// Cursor Pos mit Locate NEW 03.08.2007
// set cursor position. LCD_locate(Zeile, Position)
//------------------------------------------------------------------------------
void LCD_Locate(int Zeile, int Pos)
{

   byte Position;

   Position = 0x80;

    //Zeile bestimmen
    if (Zeile == 1)               //Zeile 1 ?
    {
      Position = (Pos - 1 + 0x80);       //Position Zeile 1 0 bis Hex07
    }

    if (Zeile == 2)               //Zeile 2 ?
    {
      Position = (Pos - 1 + 0x90);      //Position Zeile 2, 10+ da Zeile 2 bei Hex90 anfngt
    }

    if (Zeile == 3)               //Zeile 3 ?
    {
      Position = (Pos - 1 + 0xA0);      //Position Zeile 3, 20+ da Zeile 3 bei HexA0 anfngt
    }
    //Display ansteuern
    LCD_WriteCTRRegister(Position);
}
//------------------------------------------------------------------------------
// Shift Cursor left
// shift cursor position left. Refer to display specification
//------------------------------------------------------------------------------
void LCD_CursorShiftLeft (void)
{
    LCD_WriteCTRRegister(0x10);
}
//------------------------------------------------------------------------------
// Shift Cursor right
// shift cursor position right. Refer to display specification
//------------------------------------------------------------------------------
void LCD_CursorShiftRight (void)
{
    LCD_WriteCTRRegister(0x14);
}
//------------------------------------------------------------------------------
// Shift Display left
// shift display position left. Refer to display specification
//------------------------------------------------------------------------------
void LCD_DisplayShiftLeft (void)
{
    LCD_WriteCTRRegister(0x18);
}
//------------------------------------------------------------------------------
// Shift Display right
// shift display position right. Refer to display specification
//------------------------------------------------------------------------------
void LCD_DisplayShiftRight (void)
{
    LCD_WriteCTRRegister(0x1C);
}
//------------------------------------------------------------------------------
// Display double hight
// combines 2 lines to one. Refer to display specification
//------------------------------------------------------------------------------
void LCD_DisplayDoubleHight (int a)
{
    if (a == 1)
    {                //upper 2 lines
        LCD_WriteCTRRegister(0x2A);  //Table2
        LCD_WriteCTRRegister(0x18);  //UD to 0
        LCD_WriteCTRRegister(0x2C);  //DH to 1
    }
    else if (a == 2)
    {                //lower 2 lines
        LCD_WriteCTRRegister(0x2A);  //Table2
        LCD_WriteCTRRegister(0x10);  //UD to 1
        LCD_WriteCTRRegister(0x2C);  //DH to 1
    }
    else
    {
        LCD_WriteCTRRegister(0x28);  //normal 3 lines
    }
}
//------------------------------------------------------------------------------
// LCD_WriteWord(Word Variable) NEW 03.08.2007
// schreibt direkt eine Word Variable mit den Befehl LCD_WriteWord
//------------------------------------------------------------------------------
void LCD_WriteWord(word Variable, byte Length)
{
  char String[6];
  Str_WriteWord(Variable,10,String,0,Length);   // Zahl mit Basis 10, Offset 0, x stellig in String schreiben
  LCD_WriteText(String);                        // String xStellig ausgeben, rest wird mit Nullen aufgefllt
}
//------------------------------------------------------------------------------
// LCD_WriteFloat(Word Variable) NEW 12.08.2007
// schreibt direkt eine Single Variable mit den Befehl LCD_WriteFloat
//------------------------------------------------------------------------------
void LCD_WriteFloat(float Variable, byte Length)
{
  char String[20];
  Str_WriteFloat(Variable,Length,String,0);      // Variable Float wird in String x Stellig gewandelt
  LCD_WriteText(String);                        // String xStellig ausgeben, rest wird mit Nullen aufgefllt
}
//------------------------------------------------------------------------------
// Clear LCD
// clears the Display and switches cursor on
//------------------------------------------------------------------------------
void LCD_ClearLCD(void)
{
    LCD_WriteCTRRegister(0x01);
    //LCD_WriteCTRRegister(0x0f);  'Cursor wird nach lschen wieder eingeschalten
}
//-----------------------------------------------------------------------------
//------------------------------------------------------------------------------
// writes Text to LCD
//------------------------------------------------------------------------------
void LCD_WriteText(char text[])
{
    int i;

    i=0;

    while(text[i]) LCD_WriteChar(text[i++]);
}
