/*** ADCParams.h ***/
//-----------------------------------------------
 #pragma once
//-----------------------------------------------
 using namespace System;
 using namespace System::Windows::Forms;
//-----------------------------------------------
 public ref class CADCParams
    {
    private:
        initonly Int32 mi_channel;
        String ^ ms_name;
        UInt16 mui_value;
        UInt32 mui_count;
        UInt32 mui_interval;
        Single mf_max;
        Single mf_min;
        Boolean mbo_status;
    public:
        CADCParams(Int32 i_channel);
        virtual ~CADCParams(void);
        property Int32 Channel
            {
            Int32 get(void) { return mi_channel; }
            }
        property String ^ Name
            {
            String ^ get(void) { return ms_name; }
            void set(String ^ s_name) { ms_name = s_name; }
            }
        property UInt16 Value
            {
            UInt16 get(void) { return mui_value; }
            void set(UInt16 ui_value) { mui_value = ui_value; }
            }
        property UInt32 Count
            {
            UInt32 get(void) { return mui_count; }
            void set(UInt32 ui_count) { mui_count = ui_count; }
            }
        property UInt32 Interval
            {
            UInt32 get(void) { return mui_interval; }
            void set(UInt32 ui_interval) { mui_interval = ui_interval; }
            }
        property Single Scaled
            {
            Single get(void) { return ((mf_max - mf_min) * (Convert::ToSingle(mui_value) / 1023.0f)) + mf_min; }
            }
        property Single Max
            {
            Single get(void) { return mf_max; }
            void set(Single f_max) { mf_max = f_max; }
            }
        property Single Min
            {
            Single get(void) { return mf_min; }
            void set(Single f_min) { mf_min = f_min; }
            }
        property Boolean Status
            {
            Boolean get(void) { return mbo_status; }
            void set(Boolean bo_status) { mbo_status = bo_status; }
            }
    };
//-----------------------------------------------
