/*** SetADCParams.h ***/
//-----------------------------------------------
 #pragma once
 #include "ADCParams.h"
 #include "SqlDataBase.h"
//-----------------------------------------------
 using namespace System;
 using namespace System::ComponentModel;
 using namespace System::Collections;
 using namespace System::Windows::Forms;
 using namespace System::Data;
 using namespace System::Drawing;
//-----------------------------------------------
 namespace StoreAnalogValues002
    {
//-----------------------------------------------
/// <summary>
/// Zusammenfassung fr SetADCParams
///
/// Warnung: Wenn Sie den Namen dieser Klasse ndern, mssen Sie auch
///          die Ressourcendateiname-Eigenschaft fr das Tool zur Kompilierung verwalteter Ressourcen ndern,
///          das allen RESX-Dateien zugewiesen ist, von denen diese Klasse abhngt.
///          Anderenfalls knnen die Designer nicht korrekt mit den lokalisierten Ressourcen
///          arbeiten, die diesem Formular zugewiesen sind.
/// </summary>
//-----------------------------------------------
 public ref class SetADCParams : public System::Windows::Forms::Form
    {
//-----------------------------------------------
 public: SetADCParams(void)
    {
    InitializeComponent();
//
//TODO: Konstruktorcode hier hinzufgen.
//
    }
//-----------------------------------------------
 public: SetADCParams(CADCParams ^ o_params) :
    mo_params(o_params)
    {
    InitializeComponent();
    textBox_value_name->Text = mo_params->Name;
    textBox_max_real_value->Text = mo_params->Max.ToString();
    textBox_min_real_value->Text = mo_params->Min.ToString();
    textBox_interval->Text = mo_params->Interval.ToString();

    if(CSqlDataBase::IsOpen)
        button_clear_table->Enabled = true;
    }
//-----------------------------------------------
/// <summary>
/// Verwendete Ressourcen bereinigen.
/// </summary>
//-----------------------------------------------
 protected: ~SetADCParams()
    {
    if (components)
        {
        delete components;
        }
    }
//-----------------------------------------------
    private: System::Windows::Forms::Button ^ button_ok_adc_settings;
    private: System::Windows::Forms::Button ^ button_cancel_adc_settings;
    private: System::Windows::Forms::Label ^ label_value_name;
    public: System::Windows::Forms::TextBox ^ textBox_value_name;
    private: System::Windows::Forms::Label ^ label_max_real_value;
    public: System::Windows::Forms::TextBox ^ textBox_max_real_value;
    private: System::Windows::Forms::Label ^ label_min_real_value;
    public: System::Windows::Forms::TextBox ^ textBox_min_real_value;
    private: System::Windows::Forms::Label ^ label_interval;
    public: System::Windows::Forms::TextBox ^ textBox_interval;
    private: System::Windows::Forms::Button ^ button_clear_table;
/// <summary>
/// Erforderliche Designervariable.
/// </summary>
    public: CADCParams ^ mo_params;
    private: System::ComponentModel::Container ^ components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung.
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		void InitializeComponent(void)
		{
            this->button_ok_adc_settings = (gcnew System::Windows::Forms::Button());
            this->button_cancel_adc_settings = (gcnew System::Windows::Forms::Button());
            this->label_value_name = (gcnew System::Windows::Forms::Label());
            this->textBox_value_name = (gcnew System::Windows::Forms::TextBox());
            this->label_max_real_value = (gcnew System::Windows::Forms::Label());
            this->textBox_max_real_value = (gcnew System::Windows::Forms::TextBox());
            this->label_min_real_value = (gcnew System::Windows::Forms::Label());
            this->textBox_min_real_value = (gcnew System::Windows::Forms::TextBox());
            this->label_interval = (gcnew System::Windows::Forms::Label());
            this->textBox_interval = (gcnew System::Windows::Forms::TextBox());
            this->button_clear_table = (gcnew System::Windows::Forms::Button());
            this->SuspendLayout();
            // 
            // button_ok_adc_settings
            // 
            this->button_ok_adc_settings->DialogResult = System::Windows::Forms::DialogResult::OK;
            this->button_ok_adc_settings->Location = System::Drawing::Point(33, 164);
            this->button_ok_adc_settings->Name = L"button_ok_adc_settings";
            this->button_ok_adc_settings->Size = System::Drawing::Size(75, 23);
            this->button_ok_adc_settings->TabIndex = 0;
            this->button_ok_adc_settings->Text = L"OK";
            this->button_ok_adc_settings->UseVisualStyleBackColor = true;
            // 
            // button_cancel_adc_settings
            // 
            this->button_cancel_adc_settings->DialogResult = System::Windows::Forms::DialogResult::Cancel;
            this->button_cancel_adc_settings->Location = System::Drawing::Point(308, 164);
            this->button_cancel_adc_settings->Name = L"button_cancel_adc_settings";
            this->button_cancel_adc_settings->Size = System::Drawing::Size(75, 23);
            this->button_cancel_adc_settings->TabIndex = 1;
            this->button_cancel_adc_settings->Text = L"Cancel";
            this->button_cancel_adc_settings->UseVisualStyleBackColor = true;
            // 
            // label_value_name
            // 
            this->label_value_name->AutoSize = true;
            this->label_value_name->Location = System::Drawing::Point(12, 9);
            this->label_value_name->Name = L"label_value_name";
            this->label_value_name->Size = System::Drawing::Size(85, 17);
            this->label_value_name->TabIndex = 2;
            this->label_value_name->Text = L"Value Name";
            // 
            // textBox_value_name
            // 
            this->textBox_value_name->Location = System::Drawing::Point(191, 9);
            this->textBox_value_name->Name = L"textBox_value_name";
            this->textBox_value_name->Size = System::Drawing::Size(217, 22);
            this->textBox_value_name->TabIndex = 3;
            this->textBox_value_name->TextChanged += gcnew System::EventHandler(this, &SetADCParams::textBox_value_name_TextChanged);
            // 
            // label_max_real_value
            // 
            this->label_max_real_value->AutoSize = true;
            this->label_max_real_value->Location = System::Drawing::Point(12, 44);
            this->label_max_real_value->Name = L"label_max_real_value";
            this->label_max_real_value->Size = System::Drawing::Size(169, 17);
            this->label_max_real_value->TabIndex = 4;
            this->label_max_real_value->Text = L"Max. Real Value = 5 Volts";
            // 
            // textBox_max_real_value
            // 
            this->textBox_max_real_value->Location = System::Drawing::Point(191, 44);
            this->textBox_max_real_value->Name = L"textBox_max_real_value";
            this->textBox_max_real_value->Size = System::Drawing::Size(100, 22);
            this->textBox_max_real_value->TabIndex = 5;
            this->textBox_max_real_value->TextChanged += gcnew System::EventHandler(this, &SetADCParams::textBox_max_real_value_TextChanged);
            // 
            // label_min_real_value
            // 
            this->label_min_real_value->AutoSize = true;
            this->label_min_real_value->Location = System::Drawing::Point(12, 79);
            this->label_min_real_value->Name = L"label_min_real_value";
            this->label_min_real_value->Size = System::Drawing::Size(166, 17);
            this->label_min_real_value->TabIndex = 6;
            this->label_min_real_value->Text = L"Min. Real Value = 0 Volts";
            // 
            // textBox_min_real_value
            // 
            this->textBox_min_real_value->Location = System::Drawing::Point(191, 79);
            this->textBox_min_real_value->Name = L"textBox_min_real_value";
            this->textBox_min_real_value->Size = System::Drawing::Size(100, 22);
            this->textBox_min_real_value->TabIndex = 7;
            this->textBox_min_real_value->TextChanged += gcnew System::EventHandler(this, &SetADCParams::textBox_min_real_value_TextChanged);
            // 
            // label_interval
            // 
            this->label_interval->AutoSize = true;
            this->label_interval->Location = System::Drawing::Point(12, 114);
            this->label_interval->Name = L"label_interval";
            this->label_interval->Size = System::Drawing::Size(121, 17);
            this->label_interval->TabIndex = 8;
            this->label_interval->Text = L"Interval (seconds)";
            // 
            // textBox_interval
            // 
            this->textBox_interval->Location = System::Drawing::Point(191, 114);
            this->textBox_interval->Name = L"textBox_interval";
            this->textBox_interval->Size = System::Drawing::Size(100, 22);
            this->textBox_interval->TabIndex = 9;
            this->textBox_interval->TextChanged += gcnew System::EventHandler(this, &SetADCParams::textBox_interval_TextChanged);
            // 
            // button_clear_table
            // 
            this->button_clear_table->BackColor = System::Drawing::Color::Red;
            this->button_clear_table->Enabled = false;
            this->button_clear_table->Location = System::Drawing::Point(328, 44);
            this->button_clear_table->Name = L"button_clear_table";
            this->button_clear_table->Size = System::Drawing::Size(75, 52);
            this->button_clear_table->TabIndex = 10;
            this->button_clear_table->Text = L"Clear Table";
            this->button_clear_table->UseVisualStyleBackColor = false;
            this->button_clear_table->Click += gcnew System::EventHandler(this, &SetADCParams::button_clear_table_Click);
            // 
            // SetADCParams
            // 
            this->AcceptButton = this->button_ok_adc_settings;
            this->AutoScaleDimensions = System::Drawing::SizeF(8, 16);
            this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
            this->CancelButton = this->button_cancel_adc_settings;
            this->ClientSize = System::Drawing::Size(417, 194);
            this->Controls->Add(this->button_clear_table);
            this->Controls->Add(this->textBox_interval);
            this->Controls->Add(this->label_interval);
            this->Controls->Add(this->textBox_min_real_value);
            this->Controls->Add(this->label_min_real_value);
            this->Controls->Add(this->textBox_max_real_value);
            this->Controls->Add(this->label_max_real_value);
            this->Controls->Add(this->textBox_value_name);
            this->Controls->Add(this->label_value_name);
            this->Controls->Add(this->button_cancel_adc_settings);
            this->Controls->Add(this->button_ok_adc_settings);
            this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::FixedDialog;
            this->Name = L"SetADCParams";
            this->StartPosition = System::Windows::Forms::FormStartPosition::CenterParent;
            this->Text = L"AD Channel Settings";
            this->ResumeLayout(false);
            this->PerformLayout();

        }
#pragma endregion
//-----------------------------------------------
 private: System::Void textBox_value_name_TextChanged(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    if(String::IsNullOrEmpty(this->textBox_value_name->Text))
        this->mo_params->Name = "";
    else
        this->mo_params->Name = this->textBox_value_name->Text;
    }
//-----------------------------------------------
 private: System::Void textBox_max_real_value_TextChanged(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    try
        {
        if(String::IsNullOrEmpty(this->textBox_max_real_value->Text))
            this->mo_params->Max = 5.0f;
        else
            this->mo_params->Max = Convert::ToSingle(this->textBox_max_real_value->Text);
        }
    catch(System::FormatException ^ e)
        {
        this->mo_params->Max = 5.0f;
        MessageBox::Show(e->Message, "Error Set Max. Realvalue Parameter");
        }
    }
//-----------------------------------------------
 private: System::Void textBox_min_real_value_TextChanged(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    try
        {
        if(String::IsNullOrEmpty(this->textBox_min_real_value->Text))
            this->mo_params->Min = 0.0f;
        else
            this->mo_params->Min = Convert::ToSingle(this->textBox_min_real_value->Text);
        }
    catch(System::FormatException ^ e)
        {
        this->mo_params->Min = 0.0f;
        MessageBox::Show(e->Message, "Error Set Min. Realvalue Parameter");
        }
    }
//-----------------------------------------------
 private: System::Void textBox_interval_TextChanged(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    try
        {
        if(String::IsNullOrEmpty(this->textBox_interval->Text))
            this->mo_params->Interval = 1;
        else
            this->mo_params->Interval = Convert::ToUInt32(this->textBox_interval->Text);
        }
    catch(System::FormatException ^ e)
        {
        this->mo_params->Interval = 1;
        MessageBox::Show(e->Message, "Error Set Interval Parameter");
        }
    finally
        {
        if(1 > this->mo_params->Interval)
            this->mo_params->Interval = 1;
        }
    }
//-----------------------------------------------
 private: System::Void button_clear_table_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    String ^ s_result = nullptr;
    if(
        System::Windows::Forms::DialogResult::Yes
        ==
        MessageBox::Show(this, "You really want to delete the contents of the table?", "Clear Table", MessageBoxButtons::YesNo)
        )
        {
        s_result = CSqlDataBase::ClearTable(this->mo_params->Channel);
        if("OK" != s_result)
            MessageBox::Show(s_result, "The table data could not be deleted.");
        }
    }
//-----------------------------------------------
};
}
