/*******************************************************************************

 Projekt Name:      RR_Tracking.cprj
 Bentigte Libs's:  IntFunc_lib.cc
 Dateiname:         RR_Tracking.cc
 Autor:             UlliS
 Datum:             10.12.2010
 Funktion:

 Notiz:

*******************************************************************************/

byte servo_var[30]; // Servo interne Variablen
word pan, tilt;

byte buffer[226], Daten_Buffer[10];
int count, sz, Buffer_Index,i,ix;

void main(void)
{

    Irq_SetVect(INT_TIM1CMPA,ISR);
    Timer_T1Time(25,PS_1024);

    // UART 57600 Baud
    Serial_Init_IRQ(0,buffer,40,200,SR_8BIT|SR_1STOP|SR_NO_PAR,SR_BD57600);

    // Max. 2 Servos, 20ms Intervall, Timer 3
    Servo_Init(2, 1, servo_var, 1);

    Servo_Set(13, 1500);  // Servo Impulse PB.5
    Servo_Set(14, 1500);  // Servo Impulse PB.6
    i=1500;
    ix=1500;
    pan=i;
    tilt=ix;

    AbsDelay(1000);


    while(1)
    {

        Buffer_Index=0;
        sz=0;

        AbsDelay(20);

        if(Serial_IRQ_Info(0,RS232_FIFO_RECV)!=0)
        {
            while(1)
            {
               Buffer_Index++;
               sz=Serial_ReadExt(0);
               if(sz!=13)
               {
                  Daten_Buffer[Buffer_Index]=sz;
                  if(sz==0x100)break;
               }
            }

            // 1000 bis 2000s = 0 bis 255 / 128 = Mitte
            pan=(Daten_Buffer[1]*4)+990;
            tilt=(Daten_Buffer[2]*4)+990;

        }

    }

}

void ISR(void)
{

    int irqcnt;

    if(i<pan+50)
    {
      i=i+10;
      Servo_Set(13, i);  // Servo Impulse PB.5
    }
    else if(i>pan-50)
    {
      i=i-10;
      Servo_Set(13, i);  // Servo Impulse PB.5
    }


    if(ix<tilt+50)
    {
      ix=ix+10;
      Servo_Set(14, ix);  // Servo Impulse PB.6
    }
    else if(ix>tilt-50)
    {
      ix=ix-10;
      Servo_Set(14, ix);  // Servo Impulse PB.6
    }

    irqcnt=Irq_GetCount(INT_TIM1CMPA);

}