package jr.ccloader.comm;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;

import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class ComControl implements Runnable, SerialPortEventListener
{
	private static CommPortIdentifier	portId1;
	private static ComControl           instance = null;
	private InputStream					inputStream;
	private OutputStream				outputStream;
	private SerialPort					serialPort1;
	private Thread						readThread;
	protected String			divertCode	= "10";

	static String				TimeStamp;
	
	public static ComControl getInstance() throws Exception
	{
		if (instance == null)
		{
			instance = new ComControl();
		}
		return instance;
	}
	
	private ComControl() throws Exception
	{
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        // this cycle allows to capture one to one the found ports.
        while (portList.hasMoreElements())
        {
             // Port Identifier.
             CommPortIdentifier portId = (CommPortIdentifier) portList.nextElement();
             // view the port.
             System.out.println("Port --> " + portId.getName());
        }

        try 
        {
            portId1 = CommPortIdentifier.getPortIdentifier("COM1");
        }
        catch (Exception e) 
        {
        	TimeStamp = new java.util.Date().toString();
        	System.out.println(TimeStamp + ": COM1 " + portId1);
        	System.out.println(TimeStamp + ": msg1 - " + e);
        	throw e;
        }

		try
		{
			TimeStamp = new java.util.Date().toString();
			serialPort1 = (SerialPort) portId1.open("ComControl", 2000);
			System.out.println(TimeStamp + ": " + portId1.getName()
					+ " opened for c-control input");
		}
		catch (PortInUseException e)
		{
			throw e;
		}
		try
		{
			inputStream = serialPort1.getInputStream();
			outputStream = serialPort1.getOutputStream();
		}
		catch (IOException e)
		{
			throw e;
		}
		try
		{
			serialPort1.addEventListener(this);
		}
		catch (TooManyListenersException e)
		{
			throw e;
		}
		//serialPort1.notifyOnDataAvailable(true);
		//serialPort1.notifyOnOutputEmpty(true);
		try
		{

			serialPort1.setSerialPortParams(38400, SerialPort.DATABITS_8,
					SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);

			serialPort1.setDTR(false);
			serialPort1.setRTS(false);
		}
		catch (UnsupportedCommOperationException e)
		{
		}

		readThread = new Thread(this);
		readThread.start();
	}

	public void run()
	{
		try
		{
			Thread.sleep(100);
		}
		catch (InterruptedException e)
		{
		}
	}

	public void serialEvent(SerialPortEvent event)
	{
		switch (event.getEventType())
		{
		case SerialPortEvent.BI:
		case SerialPortEvent.OE:
		case SerialPortEvent.FE:
		case SerialPortEvent.PE:
		case SerialPortEvent.CD:
		case SerialPortEvent.CTS:
		case SerialPortEvent.DSR:
		case SerialPortEvent.RI:
		case SerialPortEvent.OUTPUT_BUFFER_EMPTY:
			System.out.println("Event Buffer empty");
			break;
		case SerialPortEvent.DATA_AVAILABLE:
			try
			{
				System.out.println("Event DATA_AVAILABLE");
				byte[] buffer = new byte[1024];
				BufferedInputStream in = new BufferedInputStream(inputStream);
				int n;
				while ((n = in.read(buffer, 0, buffer.length)) > 0)
				{
					
				}
			}
			catch (IOException e)
			{
			}

			break;
		}
	}

	public InputStream getInputStream()
	{
		return inputStream;
	}

	public OutputStream getOutputStream()
	{
		return outputStream;
	}
}
