
package jr.ccloader.util;

import java.util.LinkedList;

/**
 * This class can be used to implement simple producer-consumer scenarios. A
 * producer adds work using the addWork-method while the consumer gets the work
 * using the getWork method. The latter is blocking while no work is available.
 * 
 * The size of the work queue can be used to 'peek' the queue for avaiable work.
 * However if there are multiple consumers it is not guaranteed that the work
 * that was available when the check was performed is still there.
 * 
 * @author jens riebold
 * 
 */
public class WorkQueue<type> 
{
	private LinkedList<type> myQueue = new LinkedList<type>();

	public void addWork(type o) 
	{
		synchronized (myQueue) 
		{
			myQueue.add(o);
			myQueue.notifyAll();
		}
	}

	public type getWork(long timeout) 
	{
		synchronized (myQueue) 
		{
			while (myQueue.isEmpty()) 
			{
				try 
				{
					myQueue.wait(timeout);
					break;
				} 
				catch (InterruptedException ignore) 
				{
				}
			}
			if (myQueue.isEmpty())
				return null;
			else
				return myQueue.removeFirst();
		}
	}

	public int size() 
	{
		synchronized (myQueue) 
		{
			return myQueue.size();
		}
	}
}
