
#define PortD 31                                                    // PortD=PD.7
#define PortC 18                                                    // PortC=PC.2
#define val 1                                                       // defines port as an output (1=output,0=input)
#define thread_start
#thread 0, 0, 5                                                     // main thread with task change every 5 * 10ms = 50ms
#thread 1, 128, 15                                                  // thread 1 with 128 byte RAM & task change every 15 * 10ms = 150ms
#thread 2, 128, 15                                                  // thread 2 mit 128 byte RAM & task change every 15 * 10ms = 150s

int high;                                                           // initializes an integer with the name high
int low;                                                            // initializes an integer with the name low
int delval1;                                                        // initializes an integer with the name delval1
int delval2;                                                        // initializes an integer with the name delval2





void thread1(int hi, int lo, int del){                              // creates a function with 3 integer inputs
            hi=high;                                                // sets the local variable hi equal to the global variable high
            lo=low;                                                 // sets the local variable lo equal to the global variable low
            del=delval1;                                            // sets the local variable del equal to the global variable delval1

                while(1){
                    Port_DataDirBit(PortC,val);                     // defines Port 18 as an output
                    Port_Write(PortC,hi);                           // sets the output of Port 18 to high
                    Thread_Delay(del);                              // makes a delay of 100 ms,output stays for 100 ms high
                    Port_Write(PortC,lo);                           // sets the output of Port 18 to low
                    Thread_Delay(del);                              // makes a delay of 100ms , output stays for 100ms low
                }
}
void thread2(int h, int l, int d){
            h=high;                                                 // sets the local variable h equal to the global variable high
            l=low;                                                  // sets the local variable l equal to the global variable low
            d=delval2;                                              // sets the local variable d equal to the global variable delval2
                while(1){
                    Port_DataDirBit(PortD,val);                     // defines Port 31 as an output
                    Port_Write(PortD,h);                            // sets the output of Port 31 to high
                    Thread_Delay(d);                                // makes a delay of 200ms,output stays for 200ms high
                    Port_Write(PortD,l);                            // sets the output of Port 31 to low
                    Thread_Delay(d);                                // makes a delay of 200ms, output stays for 200ms low
                }
}

void main (void){
            high=1;                                                 // writes 1 into the memory with the name high (global variable)
            low=0;                                                  // writes 0 into the memory with the name low  (global variable)
            delval1=10;                                           // writes 10 into the memory with the name delval(global variable)
            delval2=20;                                           // writes 20 into the memory with the name delval(global variable)

            Thread_Start(1,thread1);                                // starts function1 with parameters set as long as thread 1 may work
            Thread_Delay(10);                                      // delay of 100ms between function 1 and function 2
            Thread_Start(2,thread2);                                // starts function2 with parameters set
            Thread_Delay(10);                                      // delay of 100ms between function 1 and function 2

}

