/*** InputCaptureT3-0.02.cc ***/
//------------------------------------------------
// Define some time quantities (in ns):
// The length of a CPU tick
 #define CPU_TICK_NS 6.781684e1
// the range of the Input Capture Timer (= 2^16 * CPU_TICK_NS)
 #define ICT3_RANGE_NS 4.444444e6
// the length of a tick of the millisecond timer
 #define MST0_TICK_NS 9.982638e5
//------------------------------------------------
 void ICT3Init $asm("TagICT3Init") (byte by_prescaler);
 word ICT3GetCapture $asm("TagICT3GetCapture") (void);
//------------------------------------------------
 word gw_ict3_capture;
 word gw_ict3_new;
 word gw_ict3_old;
 word gaw_t0_ms_count[2] = {0, 0};
 byte gby_active_counter;
//------------------------------------------------
 void ICT3IrqCapture(void)
    {
    gw_ict3_new = ICT3GetCapture();
    gw_ict3_capture = gw_ict3_new - gw_ict3_old;
    gw_ict3_old = gw_ict3_new;
    gby_active_counter = gby_active_counter ^ 0x01;
    gaw_t0_ms_count[gby_active_counter] = 0;
    Irq_GetCount(INT_TIM3CAPT);
    }
//------------------------------------------------
 void MsT0IrqCount(void)
    {
    gaw_t0_ms_count[gby_active_counter] =
        gaw_t0_ms_count[gby_active_counter] + Irq_GetCount(INT_TIM0COMP);
    }
//------------------------------------------------
 dword GetCapture(void)
    {
    byte by_index;
    float f_overflows;
    float f_t0_time;
    dword dw_ict3;
    by_index = gby_active_counter ^ 0x01;
    f_t0_time = MST0_TICK_NS * gaw_t0_ms_count[by_index];
    f_overflows = floor(f_t0_time / ICT3_RANGE_NS);
    dw_ict3 = (0xFFFF * f_overflows) + gw_ict3_capture;
    return dw_ict3;
    }
//------------------------------------------------
 void main(void)
    {
    char ac_msg[50];
    gby_active_counter = 0;
    Irq_SetVect(INT_TIM3CAPT, ICT3IrqCapture);
    Irq_SetVect(INT_TIM0COMP, MsT0IrqCount);
    ICT3Init(PS_1);
    Timer_T0Time(230, PS0_64);
    Timer_T1PWM(11059, 5530, PS_8);
    while(1)
        {
        Str_Printf(ac_msg, "%lu\r", GetCapture());
        Msg_WriteText(ac_msg);
        Thread_Delay(43);
        }
    }
//------------------------------------------------