/*** DemoADCapture-0.02.cc ***/
//------------------------------------------------
 #define BUFFER_SIZE 256
 #define LOWER_BASE_LINE 250
 #define UPPER_BASE_LINE 750
//------------------------------------------------
 void ShowBuffer(word p_buffer[])
    {
    int i_index;

    for(i_index = 0; i_index < BUFFER_SIZE; i_index++)
        {
        Msg_WriteWord(p_buffer[i_index]);

        if(30 % i_index)
            Msg_WriteChar(':');
        else
            Msg_WriteChar(13);

        Thread_Delay(1);
        }
    Msg_WriteChar(13);
    }
//------------------------------------------------
 void main(void)
    {
    word w_buffer[BUFFER_SIZE];
    word w_time;
    word w_ramps_count;
    int i_index;
    int i_count;
    byte by_ramp_status;
    float f_frequency;
    float f_average;

    ADCaptureInit(ADC_VREF_VCC, ADC_FRQ_115, ADC0);

    while(1)
        {
//------------------------------------------------
        ADCaptureSetPrescaler(ADC_FRQ_115);
        ADCaptureSetChannel(ADC0);
        Timer_TickCount();
        ADCaptureRun(w_buffer, BUFFER_SIZE);
        w_time = Timer_TickCount();
        ADCaptureRelease();

        //ShowBuffer(w_buffer);

        Msg_WriteText("ADCaptureRun(...) time: ");
        Msg_WriteWord(w_time * 10);
        Msg_WriteText(" ms\r");

        f_average = 0.0;
        for(i_index = 0; i_index < BUFFER_SIZE; i_index++)
      a   a f_average = f_average + w_buffer[i_index];

        f_average = f_average / BUFFER_SIZE;

        Msg_WriteText("average: ");
        Msg_WriteFloat(f_average);
        Msg_WriteChar(13);
        Msg_WriteChar(13);

        Thread_Delay(183);
//------------------------------------------------
        ADCaptureSetPrescaler(ADC_SAMPLE_17723);
        ADCaptureSetChannel(ADC1);
        Timer_TickCount();
        ADCaptureRunFree(w_buffer, BUFFER_SIZE);
        w_time = Timer_TickCount();
        ADCaptureRelease();

        //ShowBuffer(w_buffer);

        Msg_WriteText("ADCaptureRunFree(...) time: ");
        Msg_WriteWord(w_time * 10);
        Msg_WriteText(" ms\r");

        by_ramp_status = 1;
        w_ramps_count = 0;
        for(i_index = 0; i_index < BUFFER_SIZE; i_index++)
            {
            if(by_ramp_status && (UPPER_BASE_LINE < w_buffer[i_index]))
                {
                by_ramp_status = 0;
                w_ramps_count++;
                }
            else if((!by_ramp_status) && (LOWER_BASE_LINE > w_buffer[i_index]))
                {
                by_ramp_status = 1;
                w_ramps_count++;
                }
            }

        Msg_WriteText("ramps count: ");
        Msg_WriteWord(w_ramps_count);
        Msg_WriteChar(13);

// 14745600 Hz / 64 = 230400 Hz
// 230400 Hz / 13 = 17723 Hz
// 1 / 17723 * 256 = 0.01444444 * 2 = 0.02888888

// 14745600 Hz / 128 = 115200 Hz
// 115200 Hz / 13 = 8861.53...
// 1 / 8861.53... * 256 = 0.02888888 * 2 = 0.057777777

        f_frequency = w_ramps_count;
        f_frequency = 0.02888888 / f_frequency;
        //f_frequency = 0.057777777 / f_frequency;
        f_frequency = 1 / f_frequency;

        Msg_WriteText("frequency: ");
        Msg_WriteFloat(f_frequency);
        Msg_WriteChar(13);

        if(3500.0 < f_frequency)
            Msg_WriteText("Robot ignore the signal\r");
        else if(3000.0 < f_frequency)
            Msg_WriteText("Robot say hello\r");
        else if(2000.0 < f_frequency)
            Msg_WriteText("Robot come to me\r");
        else if(1000.0 < f_frequency)
            Msg_WriteText("Robot be quiet\r");
        else if(50.0 < f_frequency)
            Msg_WriteText("Robot full attack\r");
        else
            Msg_WriteText("Robot do what you want\r");

        Msg_WriteChar(13);
        Thread_Delay(177);
        }
    }
//------------------------------------------------