/*** ADCapture-0.04.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #if MEGA32 || MEGA128 || AVR32

// 14745600 Hz / 128 = 115200 Hz = 115.2 kHz
 #define ADC_FRQ_115kHz 7

// 14745600 Hz / 64 = 230400 Hz = 230.4 kHz
 #define ADC_FRQ_230kHz 6

// 14745600 Hz / 32 = 460800 Hz = 460.8 kHz
 #define ADC_FRQ_460kHz 5

 #endif

 #if MEGA128CAN

// 16000000 Hz / 128 = 125000 Hz = 125 kHz
 #define ADC_FRQ_125kHz 7

// 16000000 Hz / 64 = 250000 Hz = 250 kHz
 #define ADC_FRQ_250kHz 6

 #endif
//------------------------------------------------
 void ADCaptureSetVref      $asm("TagADCaptureSetVref")      (byte by_vref);
 void ADCaptureSetPrescaler $asm("TagADCaptureSetPrescaler") (byte by_prescaler);
 void ADCaptureSetChannel   $asm("TagADCaptureSetChannel")   (byte by_channel);

// Use ADCaptureRun(...)
// when your project contains time-critical interrupt functions.
 void ADCaptureRun     $asm("TagADCaptureRun")
    (word p_buffer[], word w_buffer_size);

// Use ADCaptureRunFree(...)
// when you need a precise sampling rate.
 void ADCaptureRunFree $asm("TagADCaptureRunFree")
    (word p_buffer[], word w_buffer_size);

// Use ADCaptureRunFreeFloat(...)
// if you need the data as float for further calculations.
 void ADCaptureRunFreeFloat $asm("TagADCaptureRunFreeFloat")
    (float p_buffer[], word w_buffer_size);


// Use ADCaptureRunQuiet(...)
// when you need a more accurate measurement or
// you like to use a higher AD-Clock frequency.
 void ADCaptureRunQuiet $asm("TagADCaptureRunQuiet")
    (word p_buffer[], word w_buffer_size);

 void ADCaptureRelease $asm("TagADCaptureRelease") (void);
//------------------------------------------------
 void ADCaptureInit(
    byte by_vref,
    byte by_prescaler,
    byte by_channel
    )
    {
    ADCaptureSetVref(by_vref);
    ADCaptureSetPrescaler(by_prescaler);
    ADCaptureSetChannel(by_channel);
    }
//------------------------------------------------
 void ADCaptureShowBuffer(word p_buffer[], int i_buffer_size)
    {
    int i_index;

    for(i_index = 0; i_index < i_buffer_size; i_index++)
        {
        Msg_WriteWord(p_buffer[i_index]);

        if((1 + i_index) % 32)
            Msg_WriteChar(':');
        else
            Msg_WriteChar(13);

        Thread_Delay(1);
        }
    Msg_WriteChar(13);
    }
//------------------------------------------------
 void ADCaptureShowFloatBuffer(float p_buffer[], int i_buffer_size)
    {
    int i_index;
    char ac_msg[20];

    for(i_index = 0; i_index < i_buffer_size; i_index++)
        {
        Str_Printf(ac_msg, "%8.1f", p_buffer[i_index]);
        Msg_WriteText(ac_msg);

        if(!((1 + i_index) % 12))
            Msg_WriteChar(13);

        Thread_Delay(1);
        }
    Msg_WriteChar(13);
    }
//------------------------------------------------