/*** WriteEEPROMTable.cc ***/
//------------------------------------------------
 #define FFT_N 1024
 #define EEPROM_START_ADD 0
//------------------------------------------------
 flash int gi_table[FFT_N] = 
    {
     32767,      0,  32766,    201,  32764,    402,  32761,    603,  32757,    804,  32751,   1005,  32744,   1206,  32736,   1406,  32727,   1607,  32717,   1808,  32705,   2009,  32692,   2209,  32678,   2410,  32662,   2610,  32646,   2811,  32628,   3011, 
     32609,   3211,  32588,   3411,  32567,   3611,  32544,   3811,  32520,   4011,  32495,   4210,  32468,   4409,  32441,   4608,  32412,   4807,  32382,   5006,  32350,   5205,  32318,   5403,  32284,   5601,  32249,   5799,  32213,   5997,  32176,   6195, 
     32137,   6392,  32097,   6589,  32056,   6786,  32014,   6982,  31970,   7179,  31926,   7375,  31880,   7571,  31833,   7766,  31785,   7961,  31735,   8156,  31684,   8351,  31633,   8545,  31580,   8739,  31525,   8932,  31470,   9126,  31413,   9319, 
     31356,   9511,  31297,   9703,  31236,   9895,  31175,  10087,  31113,  10278,  31049,  10469,  30984,  10659,  30918,  10849,  30851,  11038,  30783,  11227,  30713,  11416,  30643,  11604,  30571,  11792,  30498,  11980,  30424,  12166,  30349,  12353, 
     30272,  12539,  30195,  12724,  30116,  12909,  30036,  13094,  29955,  13278,  29873,  13462,  29790,  13645,  29706,  13827,  29621,  14009,  29534,  14191,  29446,  14372,  29358,  14552,  29268,  14732,  29177,  14911,  29085,  15090,  28992,  15268, 
     28897,  15446,  28802,  15623,  28706,  15799,  28608,  15975,  28510,  16150,  28410,  16325,  28309,  16499,  28208,  16672,  28105,  16845,  28001,  17017,  27896,  17189,  27790,  17360,  27683,  17530,  27575,  17699,  27466,  17868,  27355,  18036, 
     27244,  18204,  27132,  18371,  27019,  18537,  26905,  18702,  26789,  18867,  26673,  19031,  26556,  19194,  26437,  19357,  26318,  19519,  26198,  19680,  26077,  19840,  25954,  20000,  25831,  20159,  25707,  20317,  25582,  20474,  25456,  20631, 
     25329,  20787,  25201,  20942,  25072,  21096,  24942,  21249,  24811,  21402,  24679,  21554,  24546,  21705,  24413,  21855,  24278,  22004,  24143,  22153,  24006,  22301,  23869,  22448,  23731,  22594,  23592,  22739,  23452,  22883,  23311,  23027, 
     23169,  23169,  23027,  23311,  22883,  23452,  22739,  23592,  22594,  23731,  22448,  23869,  22301,  24006,  22153,  24143,  22004,  24278,  21855,  24413,  21705,  24546,  21554,  24679,  21402,  24811,  21249,  24942,  21096,  25072,  20942,  25201, 
     20787,  25329,  20631,  25456,  20474,  25582,  20317,  25707,  20159,  25831,  20000,  25954,  19840,  26077,  19680,  26198,  19519,  26318,  19357,  26437,  19194,  26556,  19031,  26673,  18867,  26789,  18702,  26905,  18537,  27019,  18371,  27132, 
     18204,  27244,  18036,  27355,  17868,  27466,  17699,  27575,  17530,  27683,  17360,  27790,  17189,  27896,  17017,  28001,  16845,  28105,  16672,  28208,  16499,  28309,  16325,  28410,  16150,  28510,  15975,  28608,  15799,  28706,  15623,  28802, 
     15446,  28897,  15268,  28992,  15090,  29085,  14911,  29177,  14732,  29268,  14552,  29358,  14372,  29446,  14191,  29534,  14009,  29621,  13827,  29706,  13645,  29790,  13462,  29873,  13278,  29955,  13094,  30036,  12909,  30116,  12724,  30195, 
     12539,  30272,  12353,  30349,  12166,  30424,  11980,  30498,  11792,  30571,  11604,  30643,  11416,  30713,  11227,  30783,  11038,  30851,  10849,  30918,  10659,  30984,  10469,  31049,  10278,  31113,  10087,  31175,   9895,  31236,   9703,  31297, 
      9511,  31356,   9319,  31413,   9126,  31470,   8932,  31525,   8739,  31580,   8545,  31633,   8351,  31684,   8156,  31735,   7961,  31785,   7766,  31833,   7571,  31880,   7375,  31926,   7179,  31970,   6982,  32014,   6786,  32056,   6589,  32097, 
      6392,  32137,   6195,  32176,   5997,  32213,   5799,  32249,   5601,  32284,   5403,  32318,   5205,  32350,   5006,  32382,   4807,  32412,   4608,  32441,   4409,  32468,   4210,  32495,   4011,  32520,   3811,  32544,   3611,  32567,   3411,  32588, 
      3211,  32609,   3011,  32628,   2811,  32646,   2610,  32662,   2410,  32678,   2209,  32692,   2009,  32705,   1808,  32717,   1607,  32727,   1406,  32736,   1206,  32744,   1005,  32751,    804,  32757,    603,  32761,    402,  32764,    201,  32766, 
         0,  32767,   -201,  32766,   -402,  32764,   -603,  32761,   -804,  32757,  -1005,  32751,  -1206,  32744,  -1406,  32736,  -1607,  32727,  -1808,  32717,  -2009,  32705,  -2209,  32692,  -2410,  32678,  -2610,  32662,  -2811,  32646,  -3011,  32628, 
     -3211,  32609,  -3411,  32588,  -3611,  32567,  -3811,  32544,  -4011,  32520,  -4210,  32495,  -4409,  32468,  -4608,  32441,  -4807,  32412,  -5006,  32382,  -5205,  32350,  -5403,  32318,  -5601,  32284,  -5799,  32249,  -5997,  32213,  -6195,  32176, 
     -6392,  32137,  -6589,  32097,  -6786,  32056,  -6982,  32014,  -7179,  31970,  -7375,  31926,  -7571,  31880,  -7766,  31833,  -7961,  31785,  -8156,  31735,  -8351,  31684,  -8545,  31633,  -8739,  31580,  -8932,  31525,  -9126,  31470,  -9319,  31413, 
     -9511,  31356,  -9703,  31297,  -9895,  31236, -10087,  31175, -10278,  31113, -10469,  31049, -10659,  30984, -10849,  30918, -11038,  30851, -11227,  30783, -11416,  30713, -11604,  30643, -11792,  30571, -11980,  30498, -12166,  30424, -12353,  30349, 
    -12539,  30272, -12724,  30195, -12909,  30116, -13094,  30036, -13278,  29955, -13462,  29873, -13645,  29790, -13827,  29706, -14009,  29621, -14191,  29534, -14372,  29446, -14552,  29358, -14732,  29268, -14911,  29177, -15090,  29085, -15268,  28992, 
    -15446,  28897, -15623,  28802, -15799,  28706, -15975,  28608, -16150,  28510, -16325,  28410, -16499,  28309, -16672,  28208, -16845,  28105, -17017,  28001, -17189,  27896, -17360,  27790, -17530,  27683, -17699,  27575, -17868,  27466, -18036,  27355, 
    -18204,  27244, -18371,  27132, -18537,  27019, -18702,  26905, -18867,  26789, -19031,  26673, -19194,  26556, -19357,  26437, -19519,  26318, -19680,  26198, -19840,  26077, -20000,  25954, -20159,  25831, -20317,  25707, -20474,  25582, -20631,  25456, 
    -20787,  25329, -20942,  25201, -21096,  25072, -21249,  24942, -21402,  24811, -21554,  24679, -21705,  24546, -21855,  24413, -22004,  24278, -22153,  24143, -22301,  24006, -22448,  23869, -22594,  23731, -22739,  23592, -22883,  23452, -23027,  23311, 
    -23169,  23169, -23311,  23027, -23452,  22883, -23592,  22739, -23731,  22594, -23869,  22448, -24006,  22301, -24143,  22153, -24278,  22004, -24413,  21855, -24546,  21705, -24679,  21554, -24811,  21402, -24942,  21249, -25072,  21096, -25201,  20942, 
    -25329,  20787, -25456,  20631, -25582,  20474, -25707,  20317, -25831,  20159, -25954,  20000, -26077,  19840, -26198,  19680, -26318,  19519, -26437,  19357, -26556,  19194, -26673,  19031, -26789,  18867, -26905,  18702, -27019,  18537, -27132,  18371, 
    -27244,  18204, -27355,  18036, -27466,  17868, -27575,  17699, -27683,  17530, -27790,  17360, -27896,  17189, -28001,  17017, -28105,  16845, -28208,  16672, -28309,  16499, -28410,  16325, -28510,  16150, -28608,  15975, -28706,  15799, -28802,  15623, 
    -28897,  15446, -28992,  15268, -29085,  15090, -29177,  14911, -29268,  14732, -29358,  14552, -29446,  14372, -29534,  14191, -29621,  14009, -29706,  13827, -29790,  13645, -29873,  13462, -29955,  13278, -30036,  13094, -30116,  12909, -30195,  12724, 
    -30272,  12539, -30349,  12353, -30424,  12166, -30498,  11980, -30571,  11792, -30643,  11604, -30713,  11416, -30783,  11227, -30851,  11038, -30918,  10849, -30984,  10659, -31049,  10469, -31113,  10278, -31175,  10087, -31236,   9895, -31297,   9703, 
    -31356,   9511, -31413,   9319, -31470,   9126, -31525,   8932, -31580,   8739, -31633,   8545, -31684,   8351, -31735,   8156, -31785,   7961, -31833,   7766, -31880,   7571, -31926,   7375, -31970,   7179, -32014,   6982, -32056,   6786, -32097,   6589, 
    -32137,   6392, -32176,   6195, -32213,   5997, -32249,   5799, -32284,   5601, -32318,   5403, -32350,   5205, -32382,   5006, -32412,   4807, -32441,   4608, -32468,   4409, -32495,   4210, -32520,   4011, -32544,   3811, -32567,   3611, -32588,   3411, 
    -32609,   3211, -32628,   3011, -32646,   2811, -32662,   2610, -32678,   2410, -32692,   2209, -32705,   2009, -32717,   1808, -32727,   1607, -32736,   1406, -32744,   1206, -32751,   1005, -32757,    804, -32761,    603, -32764,    402, -32766,    201
    };
//------------------------------------------------
 void main(void)
    {
    word w_address;
    int i_index;

    w_address = EEPROM_START_ADD;
    for(i_index = 0; i_index < FFT_N; i_index++)
        {
        EEPROM_WriteWord(w_address, gi_table[i_index]);
        w_address = w_address + 2;
        }
    }
//------------------------------------------------
