;*** WatchDog-0.02.asm ***;
;-------------------------------------------------
; Author: Torsten Knorr, create-soft@freenet.de
;*** BUGS ***;
; Maybe you'll find some. Please let me know.
; By the way I am pleased with every kind of feedback.
;-------------------------------------------------
 .include "RegDef.inc"
;-------------------------------------------------
 .equ WDTCR  = 0x21 ; Watchdog Timer Control Register
 .equ WDE    = 0x03 ; Watch Dog Enable
 .equ WDTOE  = 0x04 ; Watchdog Change Enable
 .equ WDTPM  = 0x07 ; Watch Dog Timer Prescalar Mask
 .equ MCUCSR = 0x34 ; MCU Control and Status Register
 .equ WDRF   = 0x03 ; Watchdog Reset Flag
 .equ SREG   = 0x3F ; CPU Status Register
;-------------------------------------------------
 .ifdef TagWatchDogInit
 WatchDogInit:

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 1st parameter (by_prescaler) into R_TEMP_LOW
    ld    R_TEMP_LOW,    Z

; mask lower 3 bits
; Only for the case, the user gives us an invalid parameter
    andi  R_TEMP_LOW,    WDTPM

; set WatchdogChangeEnable and WatchDogEnable bit in register
    ldi   R_TEMP_HIGH,   (1 << WDTOE) | (1 << WDE)

; The write access may not be interrupted
    in    R_DATA_LOW,    SREG
    cli

; enable watchdog change
    out   WDTCR,         R_TEMP_HIGH

; set new prescaler and disable Watchdog Timer
    out   WDTCR,         R_TEMP_LOW

; clear the Watchdog Reset Flag
    in    R_TEMP_LOW,    MCUCSR
    andi  R_TEMP_LOW,    ~(1 << WDRF)
    out   MCUCSR,        R_TEMP_LOW

    out   SREG,          R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogSetTime
 WatchDogSetTime:

; reset Watchdog Timer
    wdr

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 1st parameter (by_prescaler) into R_TEMP_LOW
    ld    R_TEMP_LOW,    Z

; mask lower 3 bits
; only for the case, the user gives us an invalid parametre
    andi  R_TEMP_LOW,    WDTPM

; load WDTCR content in general purpose register
    in    R_TEMP_HIGH,   WDTCR

; clear the prescaler bits in register
    andi  R_TEMP_HIGH,   ~WDTPM

; set the new prescaler bits in register
    or    R_TEMP_HIGH,   R_TEMP_LOW

; set WDTOE and WDE bit in register
    ldi   R_TEMP_LOW,    (1 << WDTOE) | (1 << WDE)

; The write access may not be interrupted
    in    R_DATA_LOW,    SREG
    cli

; enable Watchdog Timer change
    out   WDTCR,         R_TEMP_LOW

; set new prescaler and the old state of WDE bit
    out   WDTCR,         R_TEMP_HIGH

; reset Watchdog Timer to start new timeout
    wdr

    out   SREG,          R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogStart
 WatchDogStart:

; reset Watchdog Timer
    wdr

; load WDTCR content in general purpose register
    in    R_TEMP_LOW,    WDTCR

; set Watchdog Timer enable bit
    ori   R_TEMP_LOW,    (1 << WDE)

; start Watchdog Timer
    out   WDTCR,         R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogStop
 WatchDogStop:

; reset Watchdog Timer
    wdr

; load old WDTCR content in general purpose registrer
   in   R_TEMP_LOW,  WDTCR

; clear Watchdog Timer enable bit
   andi   R_TEMP_LOW,    ~(1 << WDE)

; set WDTOE and WDE bit in register
    ldi   R_TEMP_HIGH,   (1 << WDTOE) | (1 << WDE)

; The write access may not be interrupted
    in    R_DATA_LOW,    SREG
    cli

; enable Watchdog Timer change
    out   WDTCR,         R_TEMP_HIGH

; Turn off Watchdog Timer
    out   WDTCR,         R_TEMP_LOW

    out   SREG,          R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogReset
 WatchDogReset:

; reset Watchdog Timer
    wdr

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogResetT32

; LED2
 .equ PORTD  = 0x12
 .equ PORTD7 = 7

 WatchDogResetT:

; positive flank for the measurement
    sbi   PORTD,         PORTD7

; reset Watchdog Timer
    wdr

    cbi   PORTD,         PORTD7

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogResetT128

; LED2
 .equ PORTG  = 0x65 ; MEMORY MAPPED
 .equ PORTG4 = 4

 WatchDogResetT:

    lds   R_TEMP_LOW,    PORTG
    sbr   R_TEMP_LOW,    (1 << PORTG4)

; positive flank for the measurement
    sts   PORTG,         R_TEMP_LOW

; reset Watchdog Timer
    wdr

    cbr   R_TEMP_LOW,    (1 << PORTG4)
    sts   PORTG,         R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
; It doesn't work properly on Mega32!
; When the program starts again after a Watchdog-Reset,
; no Watchdog-Reset-Flag is set.
 .ifdef TagWatchDogIsReset
 WatchDogIsReset:

; load the content of the MCUCSR
    in    R_TEMP_LOW,    MCUCSR

; extract the Watchdog Reset Flag
    andi  R_TEMP_LOW,    (1 << WDRF)

; copy stack pointer
     movw R_ZP_LOW,      R_SP_LOW

; add 4 to sp
    adiw  R_ZP_LOW,      0x04

; copy back to stack pointer location
    movw  R_SP_LOW,      R_ZP_LOW

; store byte value on stack
    st    Z+,            R_TEMP_LOW

; only for the case, the user stores the value in a bigger data type
    clr   R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z,             R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogClear
 WatchDogClear:

    in    R_TEMP_LOW,    MCUCSR

    andi  R_TEMP_LOW,    ~(1 << WDRF)

    out   MCUCSR,        R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagGetMCUCSR
 GetMCUCSR:

; load the content of the MCUCSR
    in    R_TEMP_LOW,    MCUCSR

; copy stack pointer
    movw  R_ZP_LOW,      R_SP_LOW

; add 4 to sp
    adiw  R_ZP_LOW,      0x04

; copy back to stack pointer location
    movw  R_SP_LOW,      R_ZP_LOW

; store byte value on stack
    st    Z+,            R_TEMP_LOW

; only for the case, the user stores the value in a bigger data type
    clr   R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z,             R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------