/*** WatchDogTest-0.02.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. WatchDog.asm
// 2. RegDef.inc
// 3. WatchDog.cc
/*** Please add the required files to your project! ***/
//------------------------------------------------
 #define PORT_HIGH         1
 #define PORT_LOW          0
 #define EEPROM_ADDR_COUNT 0
//------------------------------------------------
 void LCDShowMCUCSR(void)
    {
    LCD_ClearLCD();
    AbsDelay(200);

    LCD_CursorPos(0x00);
    LCD_WriteText(" MCUCSR ");

    LCD_CursorPos(0x40);
    LCD_WriteWord(GetMCUCSR(), 3);

    AbsDelay(1000);
    }
//------------------------------------------------
 void LCDShowResets(word w_count_resets)
    {
    LCD_ClearLCD();
    AbsDelay(200);

    LCD_CursorPos(0x00);
    LCD_WriteText("WD Reset");

    LCD_CursorPos(0x40);
    LCD_WriteWord(w_count_resets, 5);

    AbsDelay(1000);
    }
//------------------------------------------------
 void main(void)
    {
    word w_delay_time;
    word w_count_down;
    word w_count_resets;
    word w_prescaler;

    w_count_resets = EEPROM_ReadWord(EEPROM_ADDR_COUNT);
    w_count_resets++;
    EEPROM_WriteWord(EEPROM_ADDR_COUNT, w_count_resets);

    LCD_Init();

// LED2
 #ifdef MEGA32
    Port_DataDirBit(31, PORT_OUT);
    Port_WriteBit(31,   PORT_LOW);
 #elif MEGA128
    Port_DataDirBit(52, PORT_OUT);
    Port_WriteBit(52,   PORT_LOW);
 #endif

    LCDShowMCUCSR();
    LCDShowResets(w_count_resets);

 #ifdef MEGA128
    if(WatchDogIsReset());
        WatchDogClear();
 #endif

    w_delay_time = 11;
    WatchDogInit(WDT_12_MS);
    WatchDogStart();

    for(w_prescaler = WDT_12_MS; w_prescaler <= WDT_1536_MS; w_prescaler++)
        {
        WatchDogSetTime(w_prescaler);
        w_count_down = 1536 >> w_prescaler;
        while(w_count_down--)
            {
            WatchDogResetT();
            AbsDelay(w_delay_time);
            }
        w_delay_time = w_delay_time * 2;
        }
    WatchDogStop();

    LCDShowResets(w_count_resets);
    }
//------------------------------------------------