;*** SPITest.asm ***;
;-------------------------------------------------
 .include "Register.def"
;-------------------------------------------------
 .equ SREG  = 0x3f

 .equ SPDR  = 0x0f ; SPI Data Register
 .equ SPSR  = 0x0e ; SPI Status Register
 .equ SPCR  = 0x0d ; SPI Control Register

; SPSR - SPI Status Register
 .equ SPI2X = 0    ; Double SPI Speed Bit
 .equ WCOL  = 6    ; Write Collision Flag
 .equ SPIF  = 7    ; SPI Interrupt Flag

; SPCR - SPI Control Register
 .equ SPR0  = 0    ; SPI Clock Rate Select 0
 .equ SPR1  = 1    ; SPI Clock Rate Select 1
 .equ CPHA  = 2    ; Clock Phase
 .equ CPOL  = 3    ; Clock polarity
 .equ MSTR  = 4    ; Master/Slave Select
 .equ DORD  = 5    ; Data Order
 .equ SPE   = 6    ; SPI Enable
 .equ SPIE  = 7    ; SPI Interrupt Enable

 .equ PORTB = 0x18
 .equ DDRB  = 0x17
; DDRB - Port B Data Direction Register
 .equ DDB0  = 0
 .equ DDB1  = 1
 .equ DDB2  = 2
 .equ DDB3  = 3

 .equ DDR_SPI = DDRB
 .equ DD_SS   = DDB0
 .equ DD_SCK  = DDB1
 .equ DD_MOSI = DDB2
 .equ DD_MISO = DDB3

;-------------------------------------------------
 .ifdef TagSPIDoubleSpeed
 SPIDoubleSpeed:

    sbi   SPSR,          SPI2X

    ret
 .endif
;-------------------------------------------------
 .ifdef TagSPIAsmWriteBuf
 SPIAsmWriteBuf:

    in    R_DATA_LOW,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (w_count) into R_COUNT
    ld    R_COUNT_LOW,   Z+
    ld    R_COUNT_HIGH,  Z+

; load 1st parameter (p_buffer) into R_XP
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

; set chip select high
    sbi   PORTB,         0

 SPI_ASM_WRITE_BUF_LOOP:

; SPI Master Transmit start transmission of data
    ld    R_TEMP_LOW,    X+
    out   SPDR,          R_TEMP_LOW

; Wait for transmission complete
 SPI_ASM_WRITE_BUF_TRANSMIT_WAIT:
    sbis  SPSR,          SPIF
    rjmp  SPI_ASM_WRITE_BUF_TRANSMIT_WAIT
    in    R_TEMP_LOW,    SPSR

; Here we can store the received data from slave
; probably it lasts 4 cpu cycles
    in    R_TEMP_HIGH,   SPDR
    nop
    nop
    nop
    nop

; repeat SPI_ASM_WRITE_BUF_LOOP if R_COUNT is not zero
    sbiw  R_COUNT_LOW,   1
    brne  SPI_ASM_WRITE_BUF_LOOP

; release chip
    cbi   PORTB,         0

    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------