/*** PCF8574_LCD.cc ***/
//------------------------------------------------
// Before you use the library, please check the hardware interface
// between the PCF8574 port extender and the LC-Display.
// If you have different hardware, you must adjust the definitions
// in the PCF8574_Interface.h file.
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "LCD_Command.h"
 #include "PCF8574_Interface.h"
//------------------------------------------------
 byte gby_backlight_status;
//------------------------------------------------
 void LCDInit(byte by_i2c_w_addr)
    {
// Wait for more than 15ms after power on
    Thread_Delay(2);

    gby_backlight_status = LCDBackLightState(by_i2c_w_addr);
    I2C_Init(I2C_400kHz);

    I2C_Start();
    I2C_Write(by_i2c_w_addr);

    I2C_Write(LCD_INIT_8_BITS | LCD_ENABLE);
    I2C_Write(LCD_INIT_8_BITS);

// Wait for more than 4.1ms
    AbsDelay(5);
    I2C_Write(LCD_INIT_8_BITS | LCD_ENABLE);
    I2C_Write(LCD_INIT_8_BITS);

// Wait for more than 100s
    AbsDelay(1);
    I2C_Write(LCD_INIT_8_BITS | LCD_ENABLE);
    I2C_Write(LCD_INIT_8_BITS);

    I2C_Write(LCD_INIT_4_BITS | LCD_ENABLE);
    I2C_Write(LCD_INIT_4_BITS);

    I2C_Stop();

// Set display
    LCDCmd(
        by_i2c_w_addr,
        (LCD_SET | TWO_LINES | INTERFACE_4_BITS)
        );

// Entry mode set
    LCDCmd(
        by_i2c_w_addr,
        (LCD_MODE | CURSOR_MOVE_RIGHT | AUTO_SHIFT_DISABLE)
        );

// Display control
    LCDCmd(
        by_i2c_w_addr,
        (LCD_CONTROL | DISPLAY_ON | CURSOR_OFF | BLINKING_OFF)
        );

// Display clear
    LCDCmd(
        by_i2c_w_addr,
        LCD_CLEAR
        );

    }
//------------------------------------------------
 void LCDWaitIsBusy(byte by_i2c_w_addr)
    {
    byte by_data_low;
    byte by_data_high;
    byte by_time_out;

    by_time_out = LCD_TIME_OUT;
    do
        {
        I2C_Start();
        I2C_Write(by_i2c_w_addr);

        I2C_Write(LCD_CMD_R_BUSY | gby_backlight_status);
        I2C_Write(LCD_START_BUSY | gby_backlight_status);

        I2C_Start();
        I2C_Write(by_i2c_w_addr + 1);
        by_data_high = I2C_Read_NACK();

        I2C_Start();
        I2C_Write(by_i2c_w_addr);

        I2C_Write(LCD_CMD_R_BUSY | gby_backlight_status);
        I2C_Write(LCD_START_BUSY | gby_backlight_status);

        I2C_Start();
        I2C_Write(by_i2c_w_addr + 1);
        by_data_low  = I2C_Read_NACK();

        I2C_Start();
        I2C_Write(by_i2c_w_addr);
        I2C_Write(LCD_CMD_R_BUSY | gby_backlight_status);

 #if DEBUG
        if(BUSY_FLAG & by_data_high)
            Msg_WriteText("\rLCD is busy\r");
 #endif

        } while((BUSY_FLAG & by_data_high) && --by_time_out);

    I2C_Stop();

 #if DEBUG
    if(0x00 == by_time_out)
        Msg_WriteText("\rtLCD-Timeout!\r");
 #endif
    }
//------------------------------------------------
 void LCDCmd(byte by_i2c_w_addr, byte by_cmd)
    {
    byte by_data_high;
    byte by_data_low;

    by_data_high = SET_HIGH_NIBBLE(by_cmd) | gby_backlight_status;
    by_data_low  = SET_LOW_NIBBLE(by_cmd)  | gby_backlight_status;

    LCDWaitIsBusy(by_i2c_w_addr);

    I2C_Start();
    I2C_Write(by_i2c_w_addr);

    I2C_Write(by_data_high | LCD_ENABLE);
    I2C_Write(by_data_high);

    I2C_Write(by_data_low  | LCD_ENABLE);
    I2C_Write(by_data_low);

    I2C_Stop();

    }
//------------------------------------------------
 void LCDWriteChar(byte by_i2c_w_addr, char c_char)
    {
    byte by_data_high;
    byte by_data_low;

    by_data_high = SET_HIGH_NIBBLE(c_char) | LCD_DATA_REG | gby_backlight_status;
    by_data_low  = SET_LOW_NIBBLE(c_char)  | LCD_DATA_REG | gby_backlight_status;

    LCDWaitIsBusy(by_i2c_w_addr);

    I2C_Start();
    I2C_Write(by_i2c_w_addr);

    I2C_Write(by_data_high | LCD_ENABLE);
    I2C_Write(by_data_high);

    I2C_Write(by_data_low  | LCD_ENABLE);
    I2C_Write(by_data_low);

    I2C_Stop();

    }
//------------------------------------------------
 void LCDWriteString(byte by_i2c_w_addr, char p_str[])
    {
    byte by_data_high;
    byte by_data_low;
    word w_str_len;
    word w_str_pos;

    w_str_len = Str_Len(p_str);

    LCDWaitIsBusy(by_i2c_w_addr);

    I2C_Start();
    I2C_Write(by_i2c_w_addr);

    for(w_str_pos = 0; w_str_pos < w_str_len; w_str_pos++)
        {

 by_data_high = SET_HIGH_NIBBLE(p_str[w_str_pos]) | LCD_DATA_REG | gby_backlight_status;
 by_data_low  = SET_LOW_NIBBLE(p_str[w_str_pos])  | LCD_DATA_REG | gby_backlight_status;

        I2C_Write(by_data_high | LCD_ENABLE);
        I2C_Write(by_data_high);

        I2C_Write(by_data_low  | LCD_ENABLE);
        I2C_Write(by_data_low);
        }

    I2C_Stop();

    }
//------------------------------------------------
 byte LCDReadData(byte by_i2c_w_addr)
    {
    byte by_data_high;
    byte by_data_low;

    LCDWaitIsBusy(by_i2c_w_addr);

    I2C_Start();
    I2C_Write(by_i2c_w_addr);

    I2C_Write(LCD_CMD_R_DATA | gby_backlight_status);
    I2C_Write(LCD_START_DATA | gby_backlight_status);

    I2C_Start();
    I2C_Write(by_i2c_w_addr + 1);
    by_data_high = I2C_Read_NACK();

    I2C_Start();
    I2C_Write(by_i2c_w_addr);

    I2C_Write(LCD_CMD_R_DATA | gby_backlight_status);
    I2C_Write(LCD_START_DATA | gby_backlight_status);

    I2C_Start();
    I2C_Write(by_i2c_w_addr + 1);
    by_data_low  = I2C_Read_NACK();

    I2C_Start();
    I2C_Write(by_i2c_w_addr);
    I2C_Write(LCD_CMD_R_DATA | gby_backlight_status);
    I2C_Stop();

    return GET_HIGH_NIBBLE(by_data_high) | GET_LOW_NIBBLE(by_data_low);
    }
//------------------------------------------------
 byte LCDBackLightState(byte by_i2c_w_addr)
    {
    byte by_state;

    //I2C_Start();
    //I2C_Write(by_i2c_w_addr);

    I2C_Start();
    I2C_Write(by_i2c_w_addr + 1);
    by_state = I2C_Read_NACK();
    I2C_Stop();

    by_state = by_state & LCD_BACKLIGHT;

    return by_state;
    }
//------------------------------------------------
 void LCDBackLightOff(byte by_i2c_w_addr)
    {

    I2C_Start();
    I2C_Write(by_i2c_w_addr);

    I2C_Write(LCD_BACKLIGHT_OFF);

    I2C_Stop();

    gby_backlight_status = LCD_BACKLIGHT_OFF;

    }
//------------------------------------------------
 void LCDBackLightOn(byte by_i2c_w_addr)
    {

    I2C_Start();
    I2C_Write(by_i2c_w_addr);

    I2C_Write(LCD_BACKLIGHT_ON);

    I2C_Stop();

    gby_backlight_status = LCD_BACKLIGHT_ON;

    }
//------------------------------------------------
 void LCDSetCursorPos(byte by_i2c_w_addr, byte by_position)
    {

    LCDCmd(by_i2c_w_addr, LCD_DDRAM | by_position);

    }
//------------------------------------------------

