/*** SineWave.cc ***/
//------------------------------------------------
 #define SAMPLES(a) (43825 / (a))
 #define PI_0_5 (PI / 2.0)
 #define PI_1_5 (PI * 1.5)
 #define PI_2 (PI * 2.0)
 #define PI_SCALE (128.0 / PI_0_5)
 #define TWINT 7
 #define TWEN   2
 #define TWSTO 4
 #define TW_OK ((1 << TWINT) | (1 << TWEN) | (1 << TWSTO))
//------------------------------------------------
 byte SineWaveOut $asm("TagSineWaveOut") (byte p_wave[], word w_samples, word w_repetitions);
//------------------------------------------------
 void SineWaveScale(byte p_data[], byte by_samples)
    {
    int i_index;
    byte by_value;
    int i_count;
    by_value = 0xFF;
    i_count = 0;
    for(i_index = 0; i_index < by_samples; i_index++)
        {
        p_data[i_index] = by_value;
        i_count++;
        if(5 == i_count)
            {
            i_count = 0;
            by_value = by_value ^ 0xFF;
            }
        }
    }
//------------------------------------------------
 #ifdef MEGA32
//------------------------------------------------
 flash byte gaby_sine[128] =
    {
    0x00, 0x01, 0x03, 0x04, 0x06, 0x07, 0x09, 0x0A, 0x0C, 0x0E, 0x0F, 0x11, 0x12, 0x14, 0x15, 0x17,
    0x18, 0x1A, 0x1C, 0x1D, 0x1F, 0x20, 0x22, 0x23, 0x25, 0x26, 0x28, 0x29, 0x2B, 0x2C, 0x2E, 0x2F,
    0x30, 0x32, 0x33, 0x35, 0x36, 0x38, 0x39, 0x3A, 0x3C, 0x3D, 0x3F, 0x40, 0x41, 0x43, 0x44, 0x45,
    0x47, 0x48, 0x49, 0x4A, 0x4C, 0x4D, 0x4E, 0x4F, 0x51, 0x52, 0x53, 0x54, 0x55, 0x57, 0x58, 0x59,
    0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
    0x6A, 0x6B, 0x6C, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 0x70, 0x71, 0x72, 0x73, 0x73, 0x74, 0x75, 0x75,
    0x76, 0x76, 0x77, 0x77, 0x78, 0x79, 0x79, 0x7A, 0x7A, 0x7A, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7D,
    0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F // max. 127  0x7F
    };
//------------------------------------------------
 void SineWaveInit $asm("__MEGA32__") (void);
//------------------------------------------------
 void SineWaveCalculate(byte p_buffer[], word w_samples)
    {
    word w_temp_sample;
    word w_index;
    float f_angle;
    float f_step;
    f_angle = 0;
    f_step = PI_2 / w_samples;
    for(w_temp_sample = 0; w_temp_sample < w_samples; w_temp_sample++)
        {
        if(PI_0_5 > f_angle)
            {
            w_index = PI_SCALE * f_angle;
            p_buffer[w_temp_sample] = 127 + gaby_sine[w_index];
            f_angle = f_angle + f_step;
            continue;
            }
        if(PI > f_angle)
            {
            w_index = PI_SCALE * (PI_0_5 - (f_angle - PI_0_5));
            p_buffer[w_temp_sample] = 127 + gaby_sine[w_index];
            f_angle = f_angle + f_step;
            continue;
            }
        if(PI_1_5 > f_angle)
            {
            w_index = PI_SCALE * (f_angle - PI);
            p_buffer[w_temp_sample] = 127 - gaby_sine[w_index];
            f_angle = f_angle + f_step;
            continue;
            }
        w_index = PI_SCALE * (PI_0_5 - (f_angle - PI_1_5));
        p_buffer[w_temp_sample] = 127 - gaby_sine[w_index];
        f_angle = f_angle + f_step;
        }
    }
//------------------------------------------------
 #elif MEGA128
//------------------------------------------------
 void SineWaveInit $asm("__MEGA128__") (void);
//------------------------------------------------
 void SineWaveCalculate(byte p_buffer[], word w_samples)
    {
    int i_index;
    float f_angle;
    float f_step;
    f_angle = 0;
    f_step = (PI * 2) / w_samples;
    for(i_index = 0; i_index < w_samples; i_index++)
        {
        if(PI > f_angle)
            p_buffer[i_index] = (127 + 128 * sin(f_angle));
        else
            p_buffer[i_index] = (127 + 127 * sin(f_angle));
        f_angle = f_angle + f_step;
        }
    }
//------------------------------------------------
 #endif
//------------------------------------------------
