/*** DS1631.h ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
 #ifndef __DALLAS_SEMICONDUCTOR_1631__
 #define __DALLAS_SEMICONDUCTOR_1631__
//------------------------------------------------
 #define BOOL int
 #define INVALID_VALUE 210.0
 #define DS1631_MAX_VALUE 126.0
 #define DS1631_MIN_VALUE -56.0

// CONFIGURATION REGISTER
// MSb  bit_6 bit_5 bit_4 bit_3 bit_2 bit_1 LSb
// DONE THF   TLF   NVB   R1    R0    POL*  1SHOT*

// DONETemperature Conversion Done (Read Only) Power-up state = 1.
// DONE = 0. Temperature conversion is in progress.
// DONE = 1. Temperature conversion is complete.

// THFTemperature High Flag (Read/Write) Power-up state = 0.
// THF = 0. The measured temperature has not exceeded the value
//          stored in the TH register since power-up.
// THF = 1. At some point since power-up the measured temperature
//          has been higher than the value stored in the TH register.
//          THF remains a 1 until it is overwritten with a 0 by the user,
//          the power is cycled, or a Software POR command is issued.

// TLFTemperature Low Flag (Read/Write) Power-up state = 0.
// TLF = 0. The measured temperature has not been lower than the
//          value stored in the TL register since power-up.
// TLF = 1. At some point since power-up the measured temperature
//          has been lower than the value stored in the TL register.
//          TLF remains a 1 until it is overwritten with a 0 by the user,
//          the power is cycled, or a Software POR command is issued.

// NVBNV Memory Busy (Read Only) Power-up state = 0.
// NVB = 1. A write to EEPROM memory is in progress.
// NVB = 0. NV memory is not busy.

// R1Resolution Bit 1 (Read/Write) Power-up state = 1.
// Sets conversion, TH, and TL resolution.

// R0Resolution Bit 0 (Read/Write) Power-up state = 1.
// Sets conversion, TH, and TL resolution.

// POL*TOUT Polarity (Read/Write)
// Power-up state = last value written to this bit. Factory setting = 0.
// POL = 1. TOUT is active high.
// POL = 0. TOUT is active low.

// 1SHOT*Conversion Mode (Read/Write)
// Power-up state = last value written to this bit. Factory setting = 0.
// 1SHOT = 1. One-Shot Mode. The Start Convert T command initiates
//            a single temperature conversion and then the device goes
//            into a lowpower standby state.
// 1SHOT = 0. Continuous Conversion Mode. The Start Convert T
//            command initiates continuous temperature conversions.

// *Stored in EEPROM

// CONTROL BYTE
// bit_7 bit_6 bit_5 bit_4 bit_3 bit_2 bit_1 bit_0
// 1     0     0     1     A2    A1    A0    R/W

// COMMAND SET

 #define DS1631_START_CONVERT_T 0x51
// Initiates temperature conversions. If the part is in one-shot mode
// (1SHOT = 1), only one conversion is performed. In continuous mode
// (1SHOT = 0), continuous temperature conversions are performed until a
// Stop Convert T command is issued.

 #define DS1631_STOP_CONVERT_T 0x22
// Stops temperature conversions when the device is in
// continuous conversion mode (1SHOT = 0).

 #define DS1631_READ_TEMPERATURE 0xAA
// Reads last converted temperature value from the 2-byte temperature register.

 #define DS1631_ACCESS_TH 0xA1
// Reads or writes the 2-byte TH register.

 #define DS1631_ACCESS_TL 0xA2
// Reads or writes the 2-byte TL register.

 #define DS1631_ACCESS_CONFIG 0xAC
// Reads or writes the 1-byte configuration register.

 #define DS1631_SOFTWARE_POR 0x54
// Initiates a software power-on-reset (POR), which stops temperature
// conversions and resets all registers and logic to their power-up states.
// The software POR allows the user to simulate cycling the power
// without actually powering down the device.


//------------------------------------------------
 #endif
//------------------------------------------------