/*** Demo4-20mA.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. 4-20mA.h / 4-20mA.cc
/*** Please add the required files to your porject! ***/
//------------------------------------------------
 void main(void)
    {
    char ac_msg[30];

// PT1000 Transducer module with standard signal output Nr. 502163-99
// Temperature sensor Pt1000 Nr. 172430-99
// -30 ... 70.0 C
    if(CurrentLoopInit(ADC0, -30.0, 70.0))
        Msg_WriteText("PT1000 -> OK\r");
    else
        {
        Msg_WriteText("PT1000 -> ERROR\r");
        return;
        }

// Endress+Hauser Cerabar
// Order Code: PMC131-A15F1A3E
// -1.0 ... 1.0 bar
    if(CurrentLoopInit(ADC1, -1.0, 1.0))
        Msg_WriteText("Cerabar -> OK\r");
    else
        {
        Msg_WriteText("Cerabar -> ERROR\r");
        return;
        }

// Endress+Hauser Promag 50
// Order Code: 50W1H-UC0A1AA0AAAA
// 0.0 ... 50.0 m/h
    if(CurrentLoopInit(ADC2, 0.0, 50.0))
        Msg_WriteText("Promag 50 -> OK\r");
    else
        {
        Msg_WriteText("Promag 50 -> ERROR\r");
        return;
        }

// Endress+Hauser Waterpilot FMX 167
// Order Code: FMX167-A1ABB1A7
// 0.0 ... 200.0 mBar
    if(CurrentLoopInit(ADC3, 0.0, 200.0))
        Msg_WriteText("Waterpilot -> OK\r");
    else
        {
        Msg_WriteText("Waterpilot -> ERROR\r");
        return;
        }

    CurrentLoopSendValue(ADC0, 1);
    CurrentLoopSendValue(ADC1, 2);
    CurrentLoopSendValue(ADC2, 3);
    CurrentLoopSendValue(ADC3, 4);
    Thread_Delay(500);

    while(1)
        {
        Str_Printf(ac_msg, "Temperatur : %5.2f C\r", CurrentLoopRead(ADC0));
        Msg_WriteText(ac_msg);

        Str_Printf(ac_msg, "Druck      : %5.2f bar\r", CurrentLoopRead(ADC1));
        Msg_WriteText(ac_msg);

        Str_Printf(ac_msg, "Durchfluss : %5.2f m/h\r", CurrentLoopRead(ADC2));
        Msg_WriteText(ac_msg);

        Str_Printf(ac_msg, "Wasserstand: %5.2f cm\r", CurrentLoopRead(ADC3));
        Msg_WriteText(ac_msg);

        Msg_WriteChar(13);

        Thread_Delay(100);
        }

    }
//------------------------------------------------