/*** DemoHumidity.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. I2C.h / I2C.cc / I2C.asm
// 2. SensorConditioner.h / SensorConditioner.cc
// 3. Humidity.h / Humidity.cc
/*** Please add the required files to your porject! ***/
//------------------------------------------------
 #define HUMIDITY_DEFAULT_ADDR (0x78 << 1)
 #define HUMIDITY_IN_ADDR      (0x79 << 1)
 #define HUMIDITY_OUT_ADDR     (0x7A << 1)
 #define HUMIDITY_GH_ADDR      (0x7B << 1)
//------------------------------------------------
 void main(void)
    {
    char ac_msg[40];
    float f_value;

    I2CInitialize(I2C_100kHz, 0x00);

    if(SensorInit(HUMIDITY_OUT_ADDR))
        Msg_WriteText("Luftfeuchte auen       -> OK\r");
    else
        Msg_WriteText("Luftfeuchte auen       -> ERROR\r");

    if(SensorInit(HUMIDITY_IN_ADDR))
        Msg_WriteText("Luftfeuchte innen       -> OK\r");
    else
        Msg_WriteText("Luftfeuchte innen       -> ERROR\r");

    if(SensorInit(HUMIDITY_GH_ADDR))
        Msg_WriteText("Luftfeuchte Gewchshaus -> OK\r");
    else
        Msg_WriteText("Luftfeuchte Gewchshaus -> ERROR\r");

    HumiditySendValues(HUMIDITY_OUT_ADDR, 1);
    HumiditySendValues(HUMIDITY_IN_ADDR, 2);
    HumiditySendValues(HUMIDITY_GH_ADDR, 3);
    Thread_Delay(500);

    while(1)
        {
        f_value = HumidityRead(HUMIDITY_OUT_ADDR);
        if(INVALID_VALUE != f_value)
            {
            Str_Printf(ac_msg, "Luftfeuchte auen      : %5.2f %c\r", f_value, '%');
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Luftfeuchte auen      : Fehler\r");
            SensorInit(HUMIDITY_OUT_ADDR);
            }
        Thread_Delay(25);

        f_value = HumidityGetTemp(HUMIDITY_OUT_ADDR);
        if(INVALID_VALUE != f_value)
            {
            Str_Printf(ac_msg, "Temperatur auen       : %5.2f C\r", f_value);
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Tempertur auen        : Fehler\r");
            SensorInit(HUMIDITY_OUT_ADDR);
            }
        Thread_Delay(25);

 #if MEGA128 || MEGA128CAN
        f_value = HumidityDewPoint(HUMIDITY_OUT_ADDR);
        if(INVALID_VALUE != f_value)
            {
            Str_Printf(ac_msg, "Taupunkt auen         : %5.2f C\r", f_value);
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Taupunkt auen         : Fehler\r");
            SensorInit(HUMIDITY_OUT_ADDR);
            }
        Thread_Delay(25);
 #endif

        f_value = HumidityRead(HUMIDITY_IN_ADDR);
        if(INVALID_VALUE != f_value)
            {
            Str_Printf(ac_msg, "Luftfeuchte innen      : %5.2f %c\r", f_value, '%');
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Luftfeuchte innen      : Fehler\r");
            SensorInit(HUMIDITY_IN_ADDR);
            }
        Thread_Delay(25);

        f_value = HumidityGetTemp(HUMIDITY_IN_ADDR);
        if(INVALID_VALUE != f_value)
            {
            Str_Printf(ac_msg, "Temperatur innen       : %5.2f C\r", f_value);
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Temperatur innen       : Fehler\r");
            SensorInit(HUMIDITY_IN_ADDR);
            }
        Thread_Delay(25);

 #if MEGA128 || MEGA128CAN
        f_value = HumidityDewPoint(HUMIDITY_IN_ADDR);
        if(INVALID_VALUE != f_value)
            {
            Str_Printf(ac_msg, "Taupunkt innen         : %5.2f C\r", f_value);
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Taupunkt innen         : Fehler\r");
            SensorInit(HUMIDITY_IN_ADDR);
            }
        Thread_Delay(25);
 #endif

        f_value = HumidityRead(HUMIDITY_GH_ADDR);
        if(INVALID_VALUE != f_value)
            {
            Str_Printf(ac_msg, "Luftfeuchte Gewchshaus: %5.2f %c\r", f_value, '%');
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Luftfeuchte Gewchshaus: Fehler\r");
            SensorInit(HUMIDITY_GH_ADDR);
            }
        Thread_Delay(25);

        f_value = HumidityGetTemp(HUMIDITY_GH_ADDR);
        if(INVALID_VALUE != f_value)
            {
            Str_Printf(ac_msg, "Temperatur Gewchshaus : %5.2f C\r", f_value);
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Tempertur Gewchshaus  : Fehler\r");
            SensorInit(HUMIDITY_GH_ADDR);
            }
        Thread_Delay(25);

 #if MEGA128 || MEGA128CAN
        f_value = HumidityDewPoint(HUMIDITY_GH_ADDR);
        if(INVALID_VALUE != f_value)
            {
            Str_Printf(ac_msg, "Taupunkt Gewchshaus   : %5.2f C\r", f_value);
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Taupunkt Gewchshaus   : Fehler\r");
            SensorInit(HUMIDITY_GH_ADDR);
            }
        Thread_Delay(25);
 #endif

        if(I2CErrorsCount(GET))
            {
            Msg_WriteText("Errors count: ");
            Msg_WriteWord(I2CErrorsCount(GET));
            Msg_WriteChar(13);
            }

        Msg_WriteChar(13);
        Thread_Delay(500);
        }
    }
//------------------------------------------------