/*** SensorConditioner.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "SensorConditioner.h"
//------------------------------------------------
 BOOL SensorInit(byte by_write_address)
    {
    byte aby_data[2];

    Thread_Delay(5);

    aby_data[0] = CFG_SIF_TO_I2C;
    if(!I2CTransmitData(by_write_address, aby_data, 1, true))
        return false;
    Thread_Delay(5);

    aby_data[0] = START_NOM;
    if(!I2CTransmitData(by_write_address, aby_data, 1, true))
        return false;
    Thread_Delay(5);

   if(!SensorCheck(by_write_address))
        return false;
    Thread_Delay(5);

    aby_data[0] = START_CYC_RAM;
    if(!I2CTransmitData(by_write_address, aby_data, 1, true))
        return false;
    Thread_Delay(30);

    if(!I2CReceiveData(by_write_address + 1, aby_data, 2, false))
        return false;
    if(0x80 & aby_data[0])
        return false;
    Thread_Delay(5);

    if(!I2CReceiveData(by_write_address + 1, aby_data, 2, false))
        return false;
    if(0x80 & aby_data[0])
        return false;
    Thread_Delay(5);

    if(!I2CReceiveData(by_write_address + 1, aby_data, 2, false))
        return false;
    if(0x80 & aby_data[0])
        return false;
    Thread_Delay(5);

    return true;
    }
//------------------------------------------------
 word SensorSignature(word p_eepcont[])
    {
    int i_index;
    int i_count;
    word w_sign;
    word w_poly;
    word w_p;
    word w_x;

    w_sign = 0;
    w_poly = SENSOR_POLYNOM;
    for(i_index = 0; i_index < SENSOR_CRC_ADDR; i_index++)
        {
        w_sign = w_sign ^ p_eepcont[i_index];
        w_p = 0;
        w_x = w_sign & w_poly;
        for(i_count = 0; i_count < 16; i_count++)
            {
            w_p = w_p ^ w_x;
            w_x = w_x >> 1;
            }
        w_sign = w_sign << 1;
        w_sign = w_sign + (w_p & 1);
        }
    return ~w_sign;
    }
//------------------------------------------------
 word SensorReadWord(byte by_write_address, byte by_cmd)
    {
    word w_value;
    byte aby_data[2];

    aby_data[0] = by_cmd;
    if(!I2CTransmitData(by_write_address, aby_data, 1, true))
        return 0;
    Thread_Delay(5);

    aby_data[0] = 0x00;
    aby_data[1] = 0x00;
    if(!I2CReceiveData(by_write_address + 1, aby_data, 2, false))
        return 0;

    w_value = aby_data[0];
    w_value = w_value << 8;
    w_value = w_value | aby_data[1];
    return w_value;
    }
//------------------------------------------------
 BOOL SensorWriteWord(byte by_write_address, byte by_cmd, word w_data)
    {
    char ac_msg[30];
    byte aby_data[3];

    I2CReset();
    Thread_Delay(5);

    aby_data[0] = START_CM;
    if(!I2CTransmitData(by_write_address, aby_data, 1, true))
        return false;
    Thread_Delay(5);

    aby_data[0] = CFG_SIF_TO_I2C;
    if(!I2CTransmitData(by_write_address, aby_data, 1, true))
        return false;
    Thread_Delay(5);

    aby_data[0] = by_cmd;
    aby_data[1] = (w_data >> 8);
    aby_data[2] = w_data;

    Str_Printf(ac_msg, "%x : %x\r", aby_data[1], aby_data[2]);
    Msg_WriteText(ac_msg);

    if(!I2CTransmitData(by_write_address, aby_data, 3, true))
        return false;
    Thread_Delay(5);

    return true;
    }
//------------------------------------------------
 BOOL SensorCheck(byte by_write_address)
    {
    word aw_eeprom[SENSOR_EEPROM_SIZE];
    word w_sign;
    int i_index;
    byte by_cmd;

    i_index = 0;
    for(by_cmd = READ_EEP0; by_cmd <= (READ_EEP0 + SENSOR_CRC_ADDR); by_cmd++)
        aw_eeprom[i_index++] = SensorReadWord(by_write_address, by_cmd);

    w_sign = SensorSignature(aw_eeprom);
    if(w_sign == aw_eeprom[SENSOR_CRC_ADDR])
        return true;

    return false;
    }
//------------------------------------------------
 BOOL SensorSetSecondAddress(byte by_write_address, byte by_second_address)
    {
    char ac_msg[30];
    byte aby_cmd[1];
    word w_config;

    w_config = SensorReadWord(by_write_address, READ_EEP1_CFGSIF);
    Str_Printf(ac_msg, "old config %x\r", w_config);
    Msg_WriteText(ac_msg);

// Set second address
    w_config = by_second_address;
    w_config = w_config << 8;
// Set default configuration.
    w_config = w_config | SIFCFG_DEFAULT;
// Enable alternative I2C slave address.
    w_config = w_config | (1 << SIFID2E);
// Disable start window for one wire communication.
    w_config = w_config | (1 << OWIWIND);

    Str_Printf(ac_msg, "new config %x\r", w_config);
    Msg_WriteText(ac_msg);

    if(!SensorWriteWord(by_write_address, WRITE_EEP1_CFGSIF, w_config))
        return false;

    aby_cmd[0] = GEN_EEP_SIGN;
    if(!I2CTransmitData(by_write_address, aby_cmd, 1, true))
        return false;
    Thread_Delay(5);

    aby_cmd[0] = START_CYC_EEP;
    if(!I2CTransmitData(by_write_address, aby_cmd, 1, true))
        return false;
    Thread_Delay(5);

    return true;
    }
//------------------------------------------------