/*** Test1.cc ***/
//------------------------------------------------
// In this program no test should cause a watchdog reset.
// This program requires these other modules and libraries:
// 1. Regiser.def
// 2. WatchDog.asm
// 3. WatchDog.cc
/*** Please add the required files to your project! ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #define PORT_HIGH         1
 #define PORT_LOW          0
 #define NUMBER_OF_TESTS   3
//------------------------------------------------
// Comment-out the definitions if no LCD or IDE connected.
 #define OUTPUT_IDE 1
 #define OUTPUT_LCD 1
//------------------------------------------------
 void Output(char p_string[], word w_value)
    {
// output IDE
 #if OUTPUT_IDE
    Msg_WriteText(p_string);
    Msg_WriteWord(w_value);
    Msg_WriteChar(13);
 #endif

// output LCD
 #if OUTPUT_LCD
    LCD_CursorPos(0x00);
    Thread_Delay(1);
    LCD_WriteText(p_string);
    Thread_Delay(1);
    LCD_CursorPos(0x40);
    Thread_Delay(1);
    LCD_WriteWord(w_value, 5);
    Thread_Delay(100);
 #endif

    }
//------------------------------------------------
 void main(void)
    {
    byte by_count;
    word w_tests_count;

    WatchDogFlagPulse();

    Port_WriteBit(PORT_LED2,   PORT_LOW);
    Port_DataDirBit(PORT_LED2, PORT_OUT);

 #if OUTPUT_LCD
    LCD_Init();
 #endif

 #if MEAGA128_ARCH
    if(WatchDogIsReset())
        {
        Output("WDTReset", GetMCUCSR());
        WatchDogClear();
        }
    else
        {
        Output(" Normal ", GetMCUCSR());
        }
 #else
    Output("MCUCSR: ", GetMCUCSR());
 #endif

    w_tests_count = 0;
// 12 ms
    for(by_count = 0; by_count < NUMBER_OF_TESTS; by_count++)
        {
 #if MEGA32 || MEGA128
        WatchDogTest(WDT_12_MS, PS_8, 22118);
 #elif MEGA128CAN
        WatchDogTest(WDT_12_MS, PS_8, 24000);
 #endif
        w_tests_count++;
        Thread_Delay(1);
        }
    Output("test0 ms", 12);

// 24 ms
    for(by_count = 0; by_count < NUMBER_OF_TESTS; by_count++)
        {
 #if MEGA32 || MEGA128
        WatchDogTest(WDT_24_MS, PS_8, 44236);
 #elif MEGA128CAN
        WatchDogTest(WDT_24_MS, PS_8, 48000);
 #endif
        w_tests_count++;
        Thread_Delay(1);
        }
    Output("test1 ms", 24);

// 48 ms
    for(by_count = 0; by_count < NUMBER_OF_TESTS; by_count++)
        {
 #if MEGA32 || MEGA128
        WatchDogTest(WDT_48_MS, PS_64, 11059);
 #elif MEGA128CAN
        WatchDogTest(WDT_48_MS, PS_64, 12000);
 #endif
        w_tests_count++;
        Thread_Delay(1);
        }
    Output("test2 ms", 48);

// 96 ms
    for(by_count = 0; by_count < NUMBER_OF_TESTS; by_count++)
        {
 #if MEGA32 || MEGA128
        WatchDogTest(WDT_96_MS, PS_64, 22118);
 #elif MEGA128CAN
        WatchDogTest(WDT_96_MS, PS_64, 24000);
 #endif
        w_tests_count++;
        Thread_Delay(1);
        }
    Output("test3 ms", 96);

// 192 ms
    for(by_count = 0; by_count < NUMBER_OF_TESTS; by_count++)
        {
 #if MEGA32 || MEGA128
        WatchDogTest(WDT_192_MS, PS_64, 44236);
 #elif MEGA128CAN
        WatchDogTest(WDT_192_MS, PS_64, 48000);
 #endif
        w_tests_count++;
        Thread_Delay(1);
        }
    Output("test4 ms", 192);

// 384 ms
    for(by_count = 0; by_count < NUMBER_OF_TESTS; by_count++)
        {
 #if MEGA32 || MEGA128
        WatchDogTest(WDT_384_MS, PS_256, 22118);
 #elif MEGA128CAN
        WatchDogTest(WDT_384_MS, PS_256, 24000);
 #endif
        w_tests_count++;
        Thread_Delay(1);
        }
    Output("test5 ms", 384);

// 768 ms
    for(by_count = 0; by_count < NUMBER_OF_TESTS; by_count++)
        {
 #if MEGA32 || MEGA128
        WatchDogTest(WDT_768_MS, PS_256, 44236);
 #elif MEGA128CAN
        WatchDogTest(WDT_768_MS, PS_256, 48000);
 #endif
        w_tests_count++;
        Thread_Delay(1);
        }
    Output("test6 ms", 768);

// 1536 ms
    for(by_count = 0; by_count < NUMBER_OF_TESTS; by_count++)
        {
 #if MEGA32 || MEGA128
        WatchDogTest(WDT_1536_MS, PS_1024, 22118);
 #elif MEGA128CAN
        WatchDogTest(WDT_1536_MS, PS_1024, 24000);
 #endif
        w_tests_count++;
        Thread_Delay(1);
        }
    Output("test7 ms", 1536);


    Port_WriteBit(PORT_LED2, PORT_LOW);
    Output("test OK ", w_tests_count);
    }
//------------------------------------------------