/*** IRControl.cc ***/
//------------------------------------------------
 #define BOOL int

 #if MEGA32
    #define PORT_IPC_TIMER1 30
    #define PORT_EXT_INT2   10
    #define FALLING_EDGE     0
 #elif MEGA128_ARCH
    #define PORT_IPC_TIMER1 28
    #define PORT_EXT_INT2   26
    #define FALLING_EDGE     2
 #endif

// NEC-Protocol Pulse Distance Decoding
// 1 x Startbit-pause + 32 x databits-pause
 #define BITS_TO_READ 33
 #define NEC_LOW_MIN  700
 #define NEC_LOW_MAX  1300
 #define NEC_HIGH_MIN 2800
 #define NEC_HIGH_MAX 3800
//------------------------------------------------
 word gaw_ir_control_capture[BITS_TO_READ];
 byte gby_ir_control_address;
 byte gby_ir_control_command;
 BOOL gbo_ir_control_success;
//------------------------------------------------

 #if MEGA32 | MEGA128

    void IRControlStart   $asm("TagIRControlStart")      (void);

    BOOL IRControlCapture $asm("TagIRControlCapture")
        (word p_buffer[], byte by_bits_to_read);

    void IRControlStop    $asm("TagIRControlStop")       (void);

 #elif MEGA128CAN

    void IRControlStart   $asm("TagIRControlStart128Can")(void);

    BOOL IRControlCapture $asm("TagIRControlCapture128Can")
        (word p_buffer[], byte by_bits_to_read);

    void IRControlStop    $asm("TagIRControlStopCan")    (void);

 #endif

 #if MEGA32

    BOOL IRControlCaptureV2 $asm("TagIRControlCaptureV2_32")
        (word p_buffer[], byte by_bits_to_read);

 #elif MEGA128_ARCH

    BOOL IRControlCaptureV2 $asm("TagIRControlCaptureV2_128")
        (word p_buffer[], byte by_bits_to_read);

 #endif

//------------------------------------------------
 void IRControlInit(void)
    {
    gby_ir_control_address = 0x00;
    gby_ir_control_command = 0x00;
    gbo_ir_control_success = false;
    SetAsmDefinitions();

 #ifdef DEBUG
    Msg_WriteText("portpin: ");
    Msg_WriteWord(PORT_IPC_TIMER1);
    Msg_WriteChar(13);
 #endif

    Port_DataDirBit(PORT_IPC_TIMER1, PORT_IN);
    Port_WriteBit(PORT_IPC_TIMER1, 1);
    Irq_SetVect(INT_TIM1CAPT, IRControlCallback);
    }
//------------------------------------------------
 void IRControlInitV2(void)
    {
    gby_ir_control_address = 0x00;
    gby_ir_control_command = 0x00;
    gbo_ir_control_success = false;
    SetAsmDefinitions();

 #ifdef DEBUG
    Msg_WriteText("portpin: ");
    Msg_WriteWord(PORT_EXT_INT2);
    Msg_WriteChar(13);
 #endif

    Port_DataDirBit(PORT_EXT_INT2, PORT_IN);
    Port_WriteBit(PORT_EXT_INT2, 1);
    Irq_SetVect(INT_2, IRControlCallbackV2);
    }
//------------------------------------------------
 void IRControlStartV2(void)
    {
    Ext_IntEnable(INT_2, FALLING_EDGE);
    }
//------------------------------------------------
 void IRControlStopV2(void)
    {
    Ext_IntDisable(INT_2);
    }
//------------------------------------------------
 void IRControlCallback(void)
    {

    gbo_ir_control_success = IRControlCapture(
        gaw_ir_control_capture,
        BITS_TO_READ
        );

    Irq_GetCount(INT_TIM1CAPT);
    }
//------------------------------------------------
 void IRControlCallbackV2(void)
    {

    gbo_ir_control_success = IRControlCaptureV2(
        gaw_ir_control_capture,
        BITS_TO_READ
        );

    Irq_GetCount(INT_2);
    }
//------------------------------------------------
 void IRControlShowBuffer(void)
    {
    static word sw_count;
    byte by_index;

    sw_count++;
    Msg_WriteChar(13);
    Msg_WriteText("frame number: ");
    Msg_WriteWord(sw_count);
    Msg_WriteChar(13);

    for(by_index = 0; by_index < BITS_TO_READ; by_index++)
        {
        Msg_WriteWord(by_index);
        Msg_WriteText(". = ");
        Msg_WriteWord(gaw_ir_control_capture[by_index]);
        Msg_WriteChar(13);
        }
    Msg_WriteChar(13);

    }
//------------------------------------------------
 BOOL IRControlTranslateNEC(void)
    {
    byte by_index;
    byte by_mask;
    byte by_check;

// 8 address-bits
    gby_ir_control_address = 0x00;
    by_mask = 0x01;
    for(by_index = 1; by_index <= 8; by_index++)
        {
        if(
            (NEC_HIGH_MIN < gaw_ir_control_capture[by_index])
            &&
            (NEC_HIGH_MAX > gaw_ir_control_capture[by_index]))
                {
                gby_ir_control_address = gby_ir_control_address | by_mask;
                }
        else if(
            (NEC_LOW_MIN > gaw_ir_control_capture[by_index])
            &&
            (NEC_LOW_MAX < gaw_ir_control_capture[by_index]))
                {
                return false;
                }
        by_mask = by_mask << 1;
        }

 #ifdef DEBUG
    Msg_WriteText("address: ");
    Msg_WriteWord(gby_ir_control_address);
    Msg_WriteChar(13);
 #endif

// 8 inverted address-bits
    by_check = 0x00;
    by_mask  = 0x01;
    for(/*by_index = 9*/; by_index <= 16; by_index++)
        {
        if(
            (NEC_HIGH_MIN < gaw_ir_control_capture[by_index])
            &&
            (NEC_HIGH_MAX > gaw_ir_control_capture[by_index]))
                {
                by_check = by_check | by_mask;
                }
        else if(
            (NEC_LOW_MIN > gaw_ir_control_capture[by_index])
            ||
            (NEC_LOW_MAX < gaw_ir_control_capture[by_index]))
                {
                return false;
                }
        by_mask = by_mask << 1;
        }

 #ifdef DEBUG
    Msg_WriteText("inverted address: ");
    Msg_WriteWord(by_check);
    Msg_WriteChar(13);
 #endif

    if(0xFF != (by_check ^ gby_ir_control_address))
        return false;

// 8 command-bits
    gby_ir_control_command = 0x00;
    by_mask = 0x01;
    for(/*by_index = 17*/; by_index <= 24; by_index++)
        {
        if(
            (NEC_HIGH_MIN < gaw_ir_control_capture[by_index])
            &&
            (NEC_HIGH_MAX > gaw_ir_control_capture[by_index]))
                {
                gby_ir_control_command = gby_ir_control_command | by_mask;
                }
        else if(
            (NEC_LOW_MIN > gaw_ir_control_capture[by_index])
            ||
            (NEC_LOW_MAX < gaw_ir_control_capture[by_index]))
                {
                return false;
                }
        by_mask = by_mask << 1;
        }

 #ifdef DEBUG
    Msg_WriteText("command: ");
    Msg_WriteWord(gby_ir_control_command);
    Msg_WriteChar(13);
 #endif

// 8 inverted command-bits
    by_check = 0x00;
    by_mask  = 0x01;
    for(/*by_index = 25*/; by_index <= 32; by_index++)
        {
        if(
            (NEC_HIGH_MIN < gaw_ir_control_capture[by_index])
            &&
            (NEC_HIGH_MAX > gaw_ir_control_capture[by_index]))
                {
                by_check = by_check | by_mask;
                }
        else if(
            (NEC_LOW_MIN > gaw_ir_control_capture[by_index])
            ||
            (NEC_LOW_MAX < gaw_ir_control_capture[by_index]))
                {
                return false;
                }
        by_mask = by_mask << 1;
        }

 #ifdef DEBUG
    Msg_WriteText("inverted command: ");
    Msg_WriteWord(by_check);
    Msg_WriteChar(13);
 #endif

    if(0xFF != (by_check ^ gby_ir_control_command))
        return false;

    return true;
    }
//------------------------------------------------
