package jr.ccloader.devices;

/**
 * The device class that extends the abstract device class
 * =======================================================
 * @author Jens Riebold
 *
 */
public class ATMega32 extends Device
{
	/*
	 * The command and response for the different operations 
	 */
	private static final byte[] resp_gp01 = 
	{ 
		0x47, 0x50, 0x30, 0x31, 0x0D, 0x30, 0x31, 0x30, 0x31, 0x0D,	0x4F, 0x4B, 0x30, 0x0D  
	};
	private static final byte[] resp_gp01a = 
	{ 
		0x47, 0x50, 0x30, 0x31, 0x0D, 0x30, 0x31, 0x30, 0x31, 0x0D,	0x4F, 0x4B, 0x31, 0x0D  
	};
	private static final byte[] resp_gp02 = 
	{ 
		0x47, 0x50, 0x30, 0x32, 0x0D, 0x34, 0x43, 0x39, 0x41, 0x0D,	0x4F, 0x4B, 0x31, 0x0D  
	};
	private static final byte[] resp_gp00 = 
	{
		0x47, 0x50, 0x30, 0x30, 0x0D, 0x30, 0x31, 0x30, 0x32, 0x0D, 0x4F, 0x4B, 0x30, 0x0D
	};
	private static final byte[] resp_go =
	{
		0x47, 0x4F, 0x0D, 0x4F, 0x4B, 0x30, 0x0D
	};
	private static final byte[] resp_re_go = 
	{
		0x52, 0x45, 0x0D, 0x52, 0x45, 0x30, 0x30, 0x30, 0x31, 0x0D, 0x4F, 0x4B, 0x30, 0x0D, 0x10, (byte) 0xff, 0x31
	};
	private static final byte[] resp_re = 
	{
		0x52, 0x45, 0x0D, 0x4F, 0x4B, 0x30, 0x0D
	};
	private static final byte[] resp_rl = 
	{
		0x52, 0x4c, 0x0D, 0x4F, 0x4B, 0x30, 0x0D
	};
	private static final byte[] req_gp01  = { 0x47, 0x50, 0x30, 0x31, 0x0D }; 
	private static final byte[] req_gp02  = { 0x47, 0x50, 0x30, 0x32, 0x0D }; 
	private static final byte[] req_go = { 0x47, 0x4F, 0x0D };
	private static final byte[] req_gp00 = { 0x47, 0x50, 0x30, 0x30, 0x0D };
	private static final byte[] req_re = { 0x52, 0x45, 0x0D };
	private static final byte[] req_kp = { 0x4b, 0x50, 0x0D };
	private static final byte[] req_rl = { 0x52, 0x4c, 0x0D };
	
	private static final byte[] footer = { 0x10, (byte) 0xff, 0x20 };
	private static final byte[] commit = { 0x10, (byte) 0xFF, 0x21, 0x4F, 0x4B, 0x30, 0x0D };	
	private static final byte[] commit_final = { 0x4f, 0x4b, 0x30, 0x0D };	

	/*
	 * The reset sequence - we first try the sequence reset1 sequence. It will fail, if the controller is
	 * loaded with a program
	 */
	private static final byte[][]  reset1_req =       { req_re,  req_go };
	private static final byte[][]  reset1_resp =      { resp_re, resp_go };
	private static final long[]    reset1_sleep =     { 100,100 };
	private static final boolean[] reset1_hasfooter = { true, true }; 
	
	/*
	 * The second reset sequence will run, if the first sequence fails. It will reset the flash.
	 * In this state the first reset sequence will be successful. 
	 */
	private static final byte[][]  reset2_req =       { req_kp, req_re, req_rl };
	private static final byte[][]  reset2_resp =      { null, null, resp_rl };
	private static final long[]    reset2_sleep =     { 100,100,100 };
	private static final boolean[] reset2_hasfooter = { true, true, true }; 
	
	/*
	 * The is the init sequence to allow the programming
	 */
	private static final byte[][] resp = { resp_gp01, resp_gp01, resp_go, resp_gp01, resp_gp01, resp_gp00, resp_gp01 };
	private static final byte[][] req = { req_gp01,    req_gp01, req_go,  req_gp01,  req_gp01,  req_gp00,  req_gp01 };
	
	private static final boolean[] hasfooter = { true, true, true, true, true, true, true };
	private static final long[] sleep =        { 100,100,100,100,100,100,100,100,100 };
	
	public ATMega32() throws Exception
	{
		super();
	}
	
	@Override
	final byte[][] getResponseSequence(int type)
	{
		switch (type)
		{
		case LOADING:
			return resp;
		case RESET_1:
			return reset1_resp;
		case RESET_2:
			return reset2_resp;
		}
		return null;
	}

	@Override
	final byte[][] getRequestSequence(int type)
	{
		switch (type)
		{
		case LOADING:
			return req;
		case RESET_1:
			return reset1_req;
		case RESET_2:
			return reset2_req;
		}
		return null;
	}
	
	final byte[] getFooterbytes()
	{
		return footer;
	}
	
	final boolean[] hasfooterbytes(int type)
	{
		switch (type)
		{
		case LOADING:
			return hasfooter;
		case RESET_1:
			return reset1_hasfooter;
		case RESET_2:
			return reset2_hasfooter;
		}
		return null;
	}
	
	@Override
	final long[] getSleep(int type)
	{
		switch (type)
		{
		case LOADING:
			return sleep;
		case RESET_1:
			return reset1_sleep;
		case RESET_2:
			return reset2_sleep;
		}
		return null;
	}
	@Override
	public final int getMaxAddress()
	{
		return 28672;
	}

	@Override
	final int getBlockSize()
	{
		return 256;
	}

	@Override
	final byte[] getCommit()
	{
		return commit;
	}
	
	final byte[] getCommitFinal()
	{
		return commit_final;
	}
}
