/*** Test ADCapture.cc ***/
//------------------------------------------------
 #define BUFFER_SIZE 256
//------------------------------------------------
 void main(void)
 {
    float f_buffer[BUFFER_SIZE];
    int i_index;

    // ADC sample rate is calculated as follows:
    // With prescaler 128 the ADC clock frequency is 14,745,600/128 = 115200 Hz.
    // In Free Running Mode a conversion takes 13 ADC clock cycles.
    // Then the ADC sample rate is 115200/13 = 8861.54 Hz.
    // The Nyquist frequency is 8861.54/2 = 4430.77 Hz.
    // Total measure time is 256/8861.54 = 28.9 ms

    Timer_T0FRQ(104,PS0_256); // Generate 276.923 Hz sound on speaker
    // With PS0_256 T=34.7222 us.
    // 104*34.722 us = 3.61111 ms i.e. 276.923 Hz, i.e. F_nq/16.
    //Timer_T0FRQ(52,PS0_64); // Generate 2215.38 Hz sound on speaker
    // With PS0_64 T=8.68055 us.
    // 52*8.68055 us = 451.389 us i.e. 2215.38 Hz, i.e. F_nq/2.

    Thread_Delay(10);

    ADCaptureInit(ADC_VREF_BG, ADC_Clock_115kHz, ADC3);
    ADCaptureRunFree2fl(f_buffer, BUFFER_SIZE);
    ADCaptureRelease();

    Show_f_buffer(f_buffer);

    fft256(f_buffer); // duration about 290 ms
    Show_f_buffer(f_buffer);
}
//------------------------------------------------
void Show_f_buffer(float p_buffer[])
{
    int i_index;

    Msg_WriteText("y=[");

    for(i_index = 0; i_index < BUFFER_SIZE; i_index++)
    {
        Msg_WriteFloat(p_buffer[i_index]);

        if((i_index+1) % 5)
            Msg_WriteText("; ");
        else
            Msg_WriteText(";\r   ");
    }
    Msg_WriteText("];\r");
}
