//========================== Hauptprogramm =====================================

/*------------------------------------------------------------------------------

   Ansteuereinheit Haussteuerung mit Touchdisplay
   Hauptprogramm:   Haussteuerung.cc
   Autor:           Josef Reininger
   Datum:           siehe SW Versionen
   Version:         siehe SW Versionen
   Copyright:       JOSEF REININGER

--------------------------------------------------------------------------------
Programmfunktion:

Die Programmierung und Debuggen ist ber RS232 Nr.: 0 mglich.
Das eDIP-Graphiktouchdisplay wird ber den IIC Bus ausgelesen bzw. angesteuert.

// erforderliche Library: IntFunc_Lib.cc

// Konstante sind im File Preprozessordef defininiert.
*/
//  Valid values for WatchDog_On
void WatchDog_On $asm("tag_WDT_on")(byte prescalar);

// Needs to be called before time which is defined by WatchDog_On( prescalar) has run off.
void WatchDog_Reset $asm("tag_WDT_reset")(void);

// Turn Watch Dog off
void WatchDog_Off $asm("tag_WDT_off")(void);
//----------------------- Variablen fr I2C Bus --------------------------------
//IN1_8=Alarmkontakte
byte IN9_16, mIN9_16, IN17_24, mIN17_24;
byte TriacOUT1_8, mTriacOUT1_8, OUT1_8, mOUT1_8, OUT9_16, mOUT9_16, OUT17_24, mOUT17_24;
byte TriacHeizung, mTriacHeizung;
byte IICStatus;
//----------------------- Variable ADC -----------------------------------------
byte IntADC, LM35_Nr;
word TMP_cnt, ADC_cnt;//, mADC_cnt;
float ADC_Wert, TMP_WG_OBEN, TMP_WG_UNTEN, TMP_WG_OST, TMP_WG_WEST;
word TIMER_Ladung;
float TMP_Speicher_unten, TMP_Speicher_1_4, TMP_Speicher_2_4, TMP_Speicher_3_4,TMP_Speicher_oben;
float ENERGIE_Ladung, z_TMP_Speicher_Durchschnitt, m_TMP_Speicher_Durchschnitt, TMP_Speicher_Durchschnitt;
float TMP_HolzKessel, TMP_FBH, TMP_HK, TMP_Raum;
float TMP_WGS_DIFF;
float m_Lichtstarke, Lichtstarke;
byte dunkel, cnt_Lichtstarke;
//---------------------- Variable Uhr DCF77 ------------------------------------
byte DCF_Buffer[59];         // Buffer fr einzelne DCF Bits
byte CheckCounter;           // Zhler fr DCF Erkennung
byte BitCounter;             // Zhler fr DCF Datenarraybuffer
byte Firstflag;              // Entscheidungsbit ob eine DCF 1 anliegt
int ParMin, ParHour, ParDate;
byte DCFpar, m_DCFpar, freeCount;
byte m_second, m_minute, m_hour, second, minute, hour, day, month, year, f_Sommer;
byte f_R_Sommer, f_second, f_minute, f_hour;
byte mRTC, DCF_MODE, DCF_synch;
//----------------- Windgeschwindigkeit/Frequenzmessung ------------------------
word Windgesch, m_Windgesch;
//------------- Definition Variablen Temperaturmessung UTI ---------------------
byte mUTI, xDraht, UTI_read, UTI_Nr, UTI_Nr_error, UTIwatch;
byte avrg, countPuls, TMP_count;
float UTI_Puls[10];
float T0, T1, T2, R_X0, R_X1, R_X2;
float TMP_aussen, UTI1T1, UTI1T2, TMP_Ofen, TMP_Rauchgas, UTI2T2, UTI3T0, UTI3T1, UTI3T2;
float TMP_aussen1, TMP_aussen2, TMP_aussen3;
//------------------ Definitionen Wintergarten ---------------------------------
byte WGstat, toggle;
byte WGB_AUTO, m_WGB_AUTO, cntWind, WGB_Mode, WGBswitchSTAT, cntWGBdel, cntWGBmove;
byte WGF_AUTO, m_WGF_AUTO, WGF_Mode, WGFswitchSTAT, cntWGFdel, cntWGFmove;
byte WGK_AUTO, m_WGK_AUTO, WGK_Mode, WGS_AUTO, m_WGS_AUTO, WGS_Mode;
//-------------------- Definitionen Rollden Dach ------------------------------
byte R_DACHstat;
byte RS_Mode, RSswitchSTAT, cntRSdel, cntRSmove, RS_AUTO, m_RS_AUTO;
byte RB_Mode, RBswitchSTAT, cntRBdel, cntRBmove, RB_AUTO, m_RB_AUTO;
byte RK_Mode, RKswitchSTAT, cntRKdel, cntRKmove, RK_AUTO, m_RK_AUTO;
//------------------------- Rolllden allg. Variable ---------------------------
byte cntRmove, cnt_Rolladen, f_Rolladen;
//-------------------- Definitionen Rolllden Kche ----------------------------
byte R_Kstat;
byte RKN_Mode, RKN_AUTO, m_RKN_AUTO;
byte RKO_Mode, RKO_AUTO, m_RKO_AUTO;
//-------------------- Definitionen Rolllden Wohnzimmer -----------------------
byte R_WZstat;
byte RWZT_Mode, RWZT_AUTO, m_RWZT_AUTO;
byte RWZS_Mode, RWZS_AUTO, m_RWZS_AUTO;
byte RWZW_Mode, RWZW_AUTO, m_RWZW_AUTO;
//-------------------- Definitionen Rolllden OG -------------------------------
byte R_OGstat;
byte RGO_Mode, RGO_AUTO, m_RGO_AUTO;
byte RGT_Mode, RGT_AUTO, m_RGT_AUTO;
byte RST_Mode, RST_AUTO, m_RST_AUTO;
byte RKW_Mode, RKW_AUTO, m_RKW_AUTO;
//------------------ Definitionen Alarmanlage ----------------------------------
byte Alarmkontakte, AlarmCheck, m_CHECKSekunde, Alarmtime;
byte Alarm_Start, Alarm_Ende, StiegeLicht, f_peep;
//------------------ Definition Bewsserung Balkonblumen -----------------------
byte BLicht_Mode, BLichtStart, BLichtLauf, cnt_BLicht;
//byte Bewassrg_Mode, BewassrgStart1, BewassrgLauf1, BewassrgStart2, BewassrgLauf2;
//byte cnt_Bewassrg;
//------------------ Definition Zentralstaubsauger Teichpumpe ------------------
byte ZSaugMode, ZSaugerNachl, ZSaug_second, ZSaug_minute;
word ZSaug_hour;
byte TeichpHANDmode, TeichpAUTOmode, cnt_Teichp, TeichpStart1, TeichpLauf1;
byte m_TeichpAUTOmode, TeichpStart2, TeichpLauf2;
//----------------- Definition globaler Variablen eDIP--------------------------
char Tasten_Dat[eDIP_Dat_limit+1];          // Array fr Tasten/Schalter
byte i, page, m_page, m_menu, menu, eDIP_dimm, Adr_eDIP, len, len_eDIP;
byte bcc_eDIP, IIC_Status;
byte eDIP_Daten[eDIP_Dat_limit]; // Vom Display bergebene Daten ber IIC Bus
byte eDIP_Touch;
word Txx1, Tyy1, Txx2, Tyy2, TXTxx1, TXTyy1;
byte Tup, Tdown, cnt_dimmen;
char Zeichenkette[Zeichenlimit+1]; // Zeichen die auf das Display ausgegeben werden
word Reset_cnt;
//------------------------- WR- Schnittstelle ----------------------------------
char ausgabe[40];
byte count, PIC_cnt, byte_anz, WR_message;
byte buffer[58];                                // Array deklariert 28
byte WR_Solarspg, WR_Netzspg, WR_Temp, WR_Check, Check;
word WR_power;
byte sz, cnt_second, f_90ms;
//------------------------- Solaranlage Pumpensteerung -------------------------
//byte Speich_pumpAuto, Speich_pump, m_Speich_pumpAuto;
//------------------ Definition globaler Variablen FS20 ------------------------
byte FS20buffer[FSbuffer];  // Puffer fr interruptgesteuerte RS232
char FS20ausgabe[40];
byte FS20count;
byte FS20sz, FS20_STATUS;
byte FS20Error;
byte FS20ST4_Adr,FS20Befehl,FS20Erweitrg;
//------------------------------- E-KFZ ----------------------------------------
byte secondE_KFZ_Ladung, minuteE_KFZ_Ladung, hourE_KFZ_Ladung;
byte f_E_KFZ_Ladestatus, StromstossEIN_AUS, f_Stromstoss, cntE_KFZ_Error;
byte E_KFZ_Ladestatus, cnt_Strom_E_KFZ, Ladeartwahl, m_Ladeartwahl, m_E_KFZ_Ladeart;
word hourE_KFZ_Ladungges, delay_EIN_AUS, delay_ECO;
float E_KFZdigit, m_Strom_E_KFZ, Strom_E_KFZ, P_E_KFZ, E_KFZ_Ladung,EgesE_KFZ;
char E_KFZ_Zeichen[15];
//------------------------------- Heizung --------------------------------------
byte EIN1_hh, EIN1_mm, AUS1_hh, AUS1_mm, EIN2_hh, EIN2_mm, AUS2_hh, AUS2_mm;
byte GasEIN1_hh, GasEIN1_mm, GasAUS1_hh, GasAUS1_mm, GasEIN2_hh,
    GasEIN2_mm, GasAUS2_hh, GasAUS2_mm;
byte PufferEIN1_hh, PufferEIN1_mm, PufferAUS1_hh, PufferAUS1_mm, PufferEIN2_hh,
    PufferEIN2_mm, PufferAUS2_hh, PufferAUS2_mm;
byte FBH_EIN1_hh, FBH_EIN1_mm, FBH_AUS1_hh, FBH_AUS1_mm, FBH_EIN2_hh,
    FBH_EIN2_mm, FBH_AUS2_hh, FBH_AUS2_mm;
byte HeizgAUTO, WegGasEIN,GAS_EIN, HK_EIN, FBH_EIN,Ofenpumpe, HKMischerEIN, FBHMischerEIN;
byte HK_M_switchSTAT, HK_M_Mode, cntHK_Mmove, HK_Mmove;
byte FBH_M_switchSTAT, FBH_M_Mode, cntFBH_Mmove, FBH_Mmove;
byte Hzgwahl, Energiemessung;
byte HK_TmpSOLL, FBH_TmpSOLL;
//----------------------- Allgemeine Variable ----------------------------------
byte ADC_Nr, Error, m_Error, cnt10ms, cnt_Klingel, f_30ms, Start, Laufdauer;
byte Starts;
byte RS232, Urlaub;
void main(void)
{
//----------------- Deaktivieren nicht bentigter Funktionen -------------------
    SPI_Disable();
 //   Serial_Disable(0);

//----------------- Portdefinitionen -------------------------------------------
//----------------- eDIP Farbdisplay -------------------------------------------
    Port_DataDirBit(eDIP_RESET,1);   // Reset fr eDIP Display definieren
    AbsDelay(1);
    Port_WriteBit(eDIP_RESET,1);     // Port auf high; low => RESET
    Port_DataDirBit(eDIP_SBUF,0);    // eDIP Daten vorhanden -> Eingang

//-------------------- Zentralstaubsauger Ansteuerung -----------------------------------------
    Port_DataDirBit(ZSaugPower,1);
    Port_DataDirBit(ZSaugON,1);
//-------------------- UTI Ansteuerung -----------------------------------------
    Port_DataDirBit(UTI1,1);
    Port_DataDirBit(UTI2,1);
    Port_DataDirBit(UTI3,1);
//-------------------- ADC Ansteuerung -----------------------------------------
    Port_DataDirBit(ADC1_Lichtsensor,0);     //ADC1 als Eingang definieren
    Port_WriteBit(ADC1_Lichtsensor,0);       //ADC1 Eingang pull up Widerstand deaktiv
    Port_DataDirBit(MUXA,1);
    Port_DataDirBit(MUXB,1);
    Port_DataDirBit(MUXC,1);
    Port_DataDirBit(MUXD,1);
    Port_DataDirBit(ADC0_TMP_LM35,0);     //ADC0 als Eingang definieren
    Port_WriteBit(ADC0_TMP_LM35,0);       //ADC0 Eingang pull up Widerstand deaktiv
    LM35_Nr=0; ADC_Nr=0;
    Port_WriteBit(MUXA,0);
    Port_WriteBit(MUXB,0);
    Port_WriteBit(MUXC,0);
    Port_WriteBit(MUXD,0);
    Port_DataDirBit(ADC2_E_KFZ,0);        //ADC2 als Eingang definieren
    Port_WriteBit(ADC2_E_KFZ,0);          //ADC2 Eingang pull up Widerstand deaktiv
//    ADC_SetInt(ADC_VREF_BG,ADC23x200); // Festlegung der Bezugsgre des Eingangskanals
                                  // und Bestimmung des verwendeten Kanals.
                                  // In diesem Fall werden alle gemessenen
                                  // Werte auf 2,56V bezogen.
//-------------------------- PIC RESETANSTEUERUNG ------------------------------
//    Port_DataDirBit(PIC_RESET,1);      // RESET fr PIC 16F84 aufwecken
//    Port_DataDirBit(PIC_ENABLE,1);     // Enable fr PIC 16F84 Datenabfrage
//--------------------- RS 232 Umschaltung ber DC 4052 ------------------------
    Port_DataDirBit(CD4052_A,1);      // RS 232 Umschaltung
    Port_DataDirBit(CD4052_B,1);      //
//---------- Schnittstellendefinition fr WR Schnittstelle ---------------------
/*   Init RS232: 3200 bps, 8 Bit, 2 Stop, NP
     22 byte Empfangspuffer - 0 byte Sendepuffer*/
 //    Serial_Init_IRQ(1,buffer,22,0,SR_8BIT|SR_2STOP|SR_NO_PAR,287);
//------------- Schnittstellendefinition fr FS20 Sender -----------------------
    //Init RS232: 9600 bps, 8 Bit, 1 Stop, NP
//Serial_Init(FS20US_RS232,SR_8BIT|SR_1STOP|SR_NO_PAR,SR_BD9600);
//     100 byte Empfangspuffer - 50 byte Sendepuffer
 //   Serial_Init_IRQ(FS20US_RS232,FS20buffer,FS20US_Empf,FS20US_Send,
 //                   SR_8BIT|SR_1STOP|SR_NO_PAR,SR_BD9600);
// -------------------- Uhr synchronisieren ------------------------------------
    Time_Init();                            // Funktionsaufruf zur Festlegung
                                            // der Startzeit und des Startdatums.
    Port_DataDirBit(DCF_IN,0);              // DCF Port =input
    DCF_START();                            // Starten des DCF Modes
//------------------------- Frequenzerzeugung fr Testzwecke -------------------
  //  Timer_T0FRQ(100,PS0_1024);  // Der Timer wird auf die Frequenz
                                // Periode=138,9s*100=13,9ms,Frequenz= 72Hz
 //   Port_DataDirBit(48,0);     //PG0 als Eingang definieren
 //   Port_WriteBit(48,1);       //PG0 Eingang pull up Widerstand aktiv
//-------------------------- Frequenzmessung -----------------------------------
    Timer_T3CNT();             // Portbit 38

//---------------- eDIP Interrupt + IIC Bus initialisieren ---------------------
    I2C_Init(I2C_100kHz);               // I2C Bit Rate: 100 kHz

//------------------- Interruptroutine fr Zeitmessung -------------------------
    Irq_SetVect(INT_TIM2COMP,INT_10ms); // Interrupt Service Routine definieren
                                        // Timer2 erzeugt einen 10ms Interrupt
//------------------- Interruptroutine UTI -------------------------------------
    Irq_SetVect(INT_TIM1CAPT,Timer1_ISR);

//---------------------- Interruptroutine ADC ----------------------------------
    Irq_SetVect(INT_ADC,ADC_ISR);
    ADC_SetInt(ADC_VREF_BG, ADC0);
    IntADC=1;
    ADC_StartInt();
//-------------------------- Initialisierung -----------------------------------
    PORTEXPANDER_INIT();
    Port_WriteBit(UTI1,1); UTI_Nr=1; xDraht=4Draht;     //UTI1 aktivieren
    INIT();
    UTI_INIT();
    WatchDog_On(7);                             // Watchdog auf 2 sec setzten

//--------------------------- Initialisieren -----------------------------------
  //  init();

 //  FS20ST4 ();

//------------------ Programmbeginn --------------------------------------------
    while (1)                                   // Endlosschleife
    {
      if (RS232==FS20ST4_DatenRS) FS20ST4 ();
      if (RS232==FS20WS_DatenRS) FS20WS ();
      if (RS232==WR_RS)
      {
//---------- Schnittstellendefinition fr WR Schnittstelle ---------------------
/*   Init RS232: 3200 bps, 8 Bit, 2 Stop, NP
           22 byte Empfangspuffer - 0 byte Sendepuffer*/
        Port_WriteBit(CD4052_A,0);             // RS 232 auf Datenlogger stellen
        Port_WriteBit(CD4052_B,0);             // RS 232 auf Datenlogger stellen     buffer,52,0
        Serial_Init_IRQ(1,FS20buffer,FS20US_Empf,FS20US_Send,SR_8BIT|SR_2STOP|SR_NO_PAR,287);
        RS232=WR_DatenRS;
      }
      if (RS232>=FS20_RS)
      {
//Msg_WriteText("RS: ");Msg_WriteWord(m);
//------------- Schnittstellendefinition fr FS20 Sender -----------------------
//Init RS232: 9600 bps, 8 Bit, 1 Stop, NP
//Serial_Init(FS20US_RS232,SR_8BIT|SR_1STOP|SR_NO_PAR,SR_BD9600);
//     100 byte Empfangspuffer - 50 byte Sendepuffer
        Port_WriteBit(CD4052_A,1);             // RS 232 auf FS20 stellen
        Port_WriteBit(CD4052_B,0);             // RS 232 auf FS20 stellen
        Serial_Init_IRQ(FS20US_RS232,FS20buffer,FS20US_Empf,FS20US_Send,
                        SR_8BIT|SR_1STOP|SR_NO_PAR,SR_BD9600);
        switch (RS232)
        {
            case FS20ST4_RS:
            RS232=FS20ST4_DatenRS;    // Sonst wird bei FS20 automatik auf
            break;
            case FS20WS_RS:
            RS232=FS20WS_DatenRS;    // Sonst wird bei FS20 automatik auf
            break;                   // WR RS umgestellt =>Rolladen EG/OG
            case FS20page_RS:
            RS232=FS20page_DatenRS;  // Sonst wird bei FS20 automatik auf
            break;                   // WR RS umgestellt =>Rolladen EG/OG
            default:
            RS232=FS20_DatenRS;
        }                   // WR RS umgestellt =>Rolladen EG/OG
      }
      if (page!=m_page) page_change();          // Anzeigeseite aktuell halten
      if (menu!=m_menu) page_change();          // Menseite aktuell halten
      if (IntADC==1) ADC_INTlesen();            // AD-Wandlerwandlung mit Auf-
                                                // summierung abgeschlossen

//      if (IN9_16&E_KFZ_Stecker||E_KFZ_Ladestatus)  E_KFZ(); // Ladekabel wird angesteckt

      if (cnt_Lichtstarke>=ADC_Limit)
      {
        Lichtstarke=(Lichtstarke+m_Lichtstarke)/(cnt_Lichtstarke+1);
        m_Lichtstarke=0; cnt_Lichtstarke=0;
        if (E_KFZ_Ladestatus>=2) ADC_Nr=2;
        else ADC_Nr=0;
      }
      if (mRTC) RTC();
//      if (mUTI) UTI();
      if (UTIwatch>2)                           // Fehler beim UTIlesen?
      {
        Error=Error|UTI_Error;                  // UTI Fehler ins Errorfile
        if (m_Error==0) m_Error=1;              // Error fr Abfrage merken
        UTI_Nr_error=UTI_Nr;                    // Nummer des Error UTI speichern
        UTI_INIT();                             // UTI's zurcksetzten/initialisieren
        UTI_Wahl();                             // Angewhlten UTI ansteuern
        UTIwatch=0;                             // berwachungsfile zurcksetzten
        Msg_WriteText("UTI WATCHDOG");
      }
      if (Port_ReadBit(eDIP_SBUF)==0) e_DIP();
      // Bei Touchtastenbettigung Abfrage einleiten -> Touchtastenanalyse
      if (f_30ms)                       // Alle 30 ms Ports aktualisieren
      {
        PORTEXPANDER();
        f_30ms=0;
      }
 //     if (Alarmkontakte&Haust) cnt_Rolladen=15;
      if (IN9_16&Klingel)               // Klingel gedrckt?
      {
        eDIP_cmd4_8('Y','W',1,1);
        cnt_Klingel=6;                  // Klingel fr 6 Sekunden setzetn
      }
      E_KFZ_Messung();                  // Strommessung (ADC-Wandlung) muss stndig abgefragt werden
      if (f_second)
      {
//Ausgabe();

        HEIZUNG();
        if (Energiemessung) HEIZUNG_ENERGIE();
        f_second=0;
        if (IN9_16&E_KFZ_Stecker||E_KFZ_Ladestatus)  E_KFZ(); // Ladekabel wird angesteckt
      //  E_KFZ_f_second();
        if (f_peep)   // Bei Aktivierung der Alarmanlage=>kurzer Piep
        {
            eDIP_cmd4_8('Y','W',1,0);    //Piep zurcksetzen
            f_peep=0;
        }
        if (cnt_Klingel)
        {
            if (second % 2) eDIP_cmd4_8('Y','W',1,1);
            else eDIP_cmd4_8('Y','W',1,0);  // Klingel im Sekundentakt EIN/AUS
            cnt_Klingel--;
            if (cnt_Klingel==0) eDIP_cmd4_8('Y','W',1,0);
        }
        if (m_minute!=minute)               // Wird bei Wintergarten/Teichp. usw.
        {                                   // bentigt
            f_minute=1;
            m_minute=minute;
        }
        else f_minute=0;
        if (m_hour!=hour)                   // Stundenwechsel
        {
            f_hour=1;
            FS20ST4_Adr=ST4_Ventilator_FS20ADR;
            FS20Befehl=0x39; FS20Erweitrg=0x98; //0x6F;
            if (hour==20) FS20ST4 (); // Ventilator Keller ein
            if (hour==19) FS20ST4 (); // Ventilator Keller ein
            if (hour==5) FS20ST4 (); // Ventilator Keller ein
            m_hour=hour;
        }
        else f_hour=0;
        PV_ANLAGE();
        if (year>14)      // Uhr ist synchron
        {
          WINTERGARTEN();
          BLUMENLICHT();
//          BLUMENBEW();
          ROLLADEN_DACHFLACHEN();
          ROLLADEN_EG_OG();
        }
        ALARMCHECK();
        if (TeichpAUTOmode!=ModeTeichpHAND) TEICHPUMPE();      // Auto wird in DCF 77 bearbeitet
        else TEICHPUMPE_HAND();
        ZSAUGER();
        PAGE();
        ZEIT();
    //    UTIwatch++;
        if (f_minute)
        {
            cnt_dimmen++;
            H2OENTHARTG();
        }
      }
//~~~~~~~~~~~~~~~~~~~~~~ RS 232 PV-Anlage bearbeiten ~~~~~~~~~~~~~~~~~~~~~~~~~~~
      if (RS232==WR_DatenRS)
      {
        count=Serial_IRQ_Info(1,RS232_FIFO_RECV); // Empfangene Zeichenanzahl lesen
        if (count>25)
        {
          PV_RS232();
          if (page==pagePV) PV_ANZ();           // PV Anzeige sofort aktualisieren
        }
      }
//~~~~~~~~~~~~ Bildschirmbeleuchtung  zurckfahren ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      if (cnt_dimmen>=eDIPdimm_time && eDIP_dimm==eDIP_Bel_max)
      {
          if (f_Sommer) eDIP_dimm=eDIP_Bel_Sommer_min;
          else eDIP_dimm=eDIP_Bel_Winter_min;   // Variablen Dimmwert zuweisen
          eDIP_DIMMEN();                        // Wert bergeben u. einstellen
      }
      if ((hour>21 || (!Alarmkontakte&Haust)) && eDIP_dimm<eDIP_Bel_max)
      {
          eDIP_dimm=eDIP_Bel_zero;              // Variablen Dimmwert zuweisen
          eDIP_DIMMEN();                        // Wert bergeben u. einstellen
      }
      if (hour==6 && eDIP_dimm==eDIP_Bel_zero)
      {
          eDIP_dimm=eDIP_Bel_Winter_min;
          eDIP_DIMMEN();
      }
      WatchDog_Reset();                         // Watchdog wieder zurcksetzten
    }                                           // While  ENDE
}
//------------------------------ Programmende ----------------------------------