//------------ Interruptroutine fr 10 ms Interrupt des Timers2 ----------------
void INT_10ms(void)
{
//~~~~~~~~~~~~~~~~~~ Funktuhr DCF77 und Frequenzmessung ~~~~~~~~~~~~~~~~~~~~~~~~
    cnt10ms++;                            // 10ms Zhler erhhen
    if ((cnt10ms%30)==0) f_30ms=1;
    if ((cnt10ms%90)==0) f_90ms++;
    if (cnt10ms>=100)                     // Im Sekundentakt Timer auslesen ->
    {                                     // Timerwert=Frequenz in Hz
      cnt10ms=0;                          // 10 ms Zhler neu starten
      m_Windgesch=(Timer_T3GetCNT()*7)/4;   // Messwert bergeben
      Windgesch=(Windgesch+m_Windgesch)/2;
      Timer_T3CNT();                      // Messung wieder starten
      mRTC++;
//      RTC();                              // DCF Updatezeit -> Preprozesor
    }

    if (DCF_MODE)                         // Abfrage fr Ablaufzeitersparnis
    {
      switch (DCF_MODE)             // Pages whlen
      {
        case 1:
        DCF_PULS();
        break;
        case 2:
        DCF_DATASTART();
        break;
        case 3:
        DCF_COLLECT();
        break;
        case 4:
        DCF_CALC();
        break;
        case 5:
        DCF_SECOND();
        break;
      }
    }
    Irq_GetCount(INT_TIM2COMP);
}

//----------------------- UTI Bearbeitungsroutine ------------------------------
// Mega128: Zhlereingang Timer1 (input capture) PD4 (Portbit 28)
//          UTI Baustein1 PC0 (Portbit 16)
//          UTI Baustein2 PC1 (Portbit 17)
//          UTI Baustein3 PC2 (Portbit 18)


//------------------------------------------------------------------------------
// ber den Timer Prescaler wird das Teilungsverhltnis (Oszillatorfrequenz/ps)
// festgelegt. (14,7456MHz/ps)
//
/*
Vorteiler (prescaler)   Zeitbasis (Dauer eines Ticks)
PS_1    (1)   67,8 ns
PS_8    (2)  542,5 ns
PS_64   (3)   4,34 s
PS_256  (4)  17,36 s
PS_1024 (5)   69,4 s
*/
void Timer1_ISR(void)
{
   if (Timer_T1GetPM()>0)
   {
     if (Timer_T1GetPM()<Tmax)
     {
       UTI_Puls[countPuls]=Timer_T1GetPM();
  //     mUTI++;

       UTI_READ();
       UTIwatch=0;
       switch (xDraht)             // Pages whlen
       {
        case 4Draht:
        if (countPuls==5)
        {
         UTI_berechng();
         if (TMP_count>=UTI_Limit) UTI_Wahl();
        }
        break;
        case 2Draht:
        if (countPuls==6)
        {
         UTI_berechng();
         if (TMP_count>=UTI_Limit) UTI_Wahl();
        }
        break;
       }
     }
   }
   Irq_GetCount(INT_TIM1CAPT);           // Interrupt zurcksetzen
}
//----------------------- ADC Interuptabarbeitung ------------------------------
void ADC_ISR(void)
{
  IntADC=1;
/*  if (LM35_Nr==Helligkeit)
  {
    m_Lichtstarke=m_Lichtstarke+ADC_ReadInt();
    cnt_Lichtstarke++;
   // LM35_Nr=0;
  }
  else
  {
    ADC_cnt++;
    ADC_Wert=ADC_Wert+ADC_ReadInt();
  }       */
  switch (ADC_Nr)
  {
        case 0:
        ADC_cnt++;
        ADC_Wert=ADC_Wert+ADC_ReadInt();
        break;
        case 1:
        m_Lichtstarke=m_Lichtstarke+ADC_ReadInt();
        cnt_Lichtstarke++; //LM35_Nr=0;
        break;
        case 2:
        m_Strom_E_KFZ=m_Strom_E_KFZ+ADC_ReadInt();
        cnt_Strom_E_KFZ++;
        break;
  }
  Irq_GetCount(INT_ADC);      // Interrupt Request Counter
}

// ENDE -> Interruptroutine ICP <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<