;*******************************************************************************
;* Datei   : DHT22.asm
;* Autor   : J. Reininger
;* Ident   : Rev 1 21.03.2020
;* Function: Lesen des DHT22 Sensors in Assembler, da der Mega 128 in C mit
;*           Capture und Codeinterpreter ein Timingproblem hat und one-wire
;*           auch mit diesem Baustein nicht funkt.
;* Library : keine
;* Prozessor: Atmega 128 mit 14.7456 MHz Quarz
;* I/O:       PortE - PE7 fr Signalerfassung und Timer 0 fr's timing
;* Vorgangsweise:
;* - Programm ins Projekt importieren
;* - Ins C-Hauptprg void DHT22HUM_TEMP $asm("DHT22READ")(void); schreiben
;* - Globale Variablen in C definieren: int DHT_Hum;  int DHT_Temp;  int DHT_Par;
;* - Aufruf in C: DHT22HUM_TEMP();
;* - Umwandlungen der Messwerte ins richtige Format mssen in C vorgenommen werden
;* - Paritt ist nicht ok, wenn 0x0000 in DHT_Par steht.
;* Code ist nicht geschtzt, keine Gewhr auf Fehlerfreiheit
;* Fehlerbehandlungen bei den ersten Portabfragen sind realisiert
;* Danke an Peter fr die Beispielprogramme beim Assembler
;*******************************************************************************
;----------------------------- Definitionen ------------------------------------
.equ SREG = $3F
.equ Z = 1
.equ Neg = 2
.equ DDRE = $02
.equ DDE7 = 7
.equ PORTE = $03
.equ PINE = $01
.equ TCCR0 = $33
.equ TCNT0 = $32
.equ CS00 = 0
.equ CS01 = 1
.equ CS02 = 2
;----------------------- ANFANG Assemblerprogramm ------------------------------
.ifdef DHT22READ

DHT22HUM_TEMP:
;SBI     DDRE , DDE7     ; PORT E.7 = 1 Ausgang
;CBI     PORTE, DDE7     ; Port E.7 auf LOW
    PUSH    R15          ; Register sichern
    PUSH    R16

    MOVW    R26,R8              ; Ramende Addresse vom Register 8,9
    SUBI    R26,LOW(DHT_Hum)    ; DHT_Hum Addresse bestimmen
    SBCI    R27,HIGH(DHT_Hum)

    CLR     R16
    SBR     R16, (1<<CS02 | 1<<CS00)  ;clkTOS/128   8,68 s Teilung
    OUT     TCCR0,R16       ; Timer0 initialisieren

    SBI     DDRE , DDE7     ; PORT E.7 = 1 Ausgang
    NOP
    CBI     PORTE, DDE7     ; Port E.7 auf LOW
    CLR     R16
    OUT     TCNT0, R16      ; Timer auf Null
Tbe:
    IN      R16,TCNT0
    CPI     R16,250         ; 8,68s x 250 = 2,17ms
    BRNE    Tbe             ; DHT22 fr Datenbertragung mit LOW 800s auffordern
    CBI     DDRE, DDE7      ; PORT E.7 = 0 Eingang => Bus an DHT22 bergeben
    CLR     R16
    SBR     R16,(1<<CS01 | 1<<CS00)  ; clkTOS/32   2,17s Teilung
    OUT     TCCR0,R16       ; Timer0 initialisieren
    CLR     R16
    OUT     TCNT0, R16      ; Timer auf Null fr Laufzeitberwachung
Tgo:
    SBIS    PINE, DDE7      ; Signal 20s High
    RJMP    Tgo

Trel:
    SBIC    PINE, DDE7      ; Signal 80s Low
    RJMP    Trel

Treh:
    SBIS    PINE, DDE7      ; Signal 80s High
    RJMP    Treh

Tlow39:
    SBIC    PINE, DDE7      ; Signal 50s Low Hum Bit39 beginnt nach diesem LOW
    RJMP    Tlow39
    IN      R16,TCNT0
    CPI     R16,88          ; 2,17s x 92 = 200s  - ev. hher stellen, kann Bauteilabhngig sein
    BRLO    weiter          ; Max. Laufzeit von 300 s wird nicht berschritten
    RJMP    ende
weiter:
    CLR     R23             ; R23 fr Parittsberechnung
;-------------------------- Feuchte Lesen --------------------------------------
    LDI     R22,16           ; Init Register22 als Bitcounter
    CLR     R24
    CLR     R25             ; Register frs Bitlesen vorbereiten

    RCALL   READ_BYTE
    ST      X+,R24          ; L-Byte Feuchte in Speicherzelle
    ST      X,R25           ; H-Byte Feuchte in Speicherzelle
    ADD     R23,R24
    ADD     R23,R25

;---------------------------- Temeratur Lesen ----------------------------------
    MOVW    R26,R8              ; Ramende Addresse vom Register 8,9
    SUBI    R26,LOW(DHT_Temp)   ; DHT_Temp Addresse bestimmen
    SBCI    R27,HIGH(DHT_Temp)

    LDI     R22,16          ; Init Register22 als Bitcounter
    CLR     R24
    CLR     R25             ; Register frs Bitlesen vorbereiten

    RCALL   READ_BYTE
    ST      X+,R24          ; L-Byte Temeratur in Speicherzelle
    ST      X,R25           ; H-Byte Temeratur in Speicherzelle
    ADD     R23,R24
    ADD     R23,R25
;------------------------------ Paritt Lesen ----------------------------------
    MOVW    R26,R8             ; Ramende Addresse vom Register 8,9
    SUBI    R26,LOW(DHT_Par)   ; DHT_Paritt Addresse bestimmen
    SBCI    R27,HIGH(DHT_Par)

    LDI     R22,8           ; Init Register22 als Bitcounter
    CLR     R24
    CLR     R25             ; Register frs Bitlesen vorbereiten

    RCALL   READ_BYTE
    SUB     R24,R23         ; Paritt prfen
    BREQ    Par_ok          ; R23 errechnete Paritt
    CLR     R23             ; Ist Paritt falsch wird 0 in die Variable geschrieben
    CLR     R24             ; Sonst bleibt High und Low von Variable unverndert
Par_ok:
    ST      X+,R24          ; L-Byte Temeratur in Speicherzelle
    ST      X,R23           ; H-Byte Temeratur in Speicherzelle
;-------------------------------------------------------------------------------
ende:
    POP     R16
    POP     R15

  RET                       ; zurck zur C Routine
;-------------------------- ENDE Assemblerprogramm -----------------------------

;--------------------------- Bytes vom Bus Lesen -------------------------------
READ_BYTE:
Thigh:                      ; warten bis Signal high
    SBIS    PINE, DDE7      ; Signal High/Low selektieren
    RJMP    Thigh
    CLR     R16
    OUT     TCNT0,R16       ; Timer auf Null stellen, wenn Signal high
Tlow:                       ; warten bis Signal low, Timer luft
    SBIC    PINE, DDE7      ; Signal 50s Low
    RJMP    Tlow
    IN      R16,TCNT0       ; Timer lesen
    CPI     R22,9           ; LOW Byte bedienen
    BRLO    Low_byte
    LSL     R25             ; Bits links Schieben - eingelesenes Bit sichern - HIGH Byte
Low_byte:                   ; diese Postionion notwendig, da sonst bei Bit7 Position falsch ist
    LSL     R24

    CPI     R16,15          ; Timerwert kleiner 15 x 2,17 s => Bit low sonst high
    BRLO    Bit_low
    CPI     R22,9           ; LOW Byte bedienen
    BRLO    Low_byteINC
    INC     R25             ; Bit ist high - Register Bit0 vor Linksschieben mit 1 belegen
Low_byteINC:
    INC     R24
Bit_low:
    DEC     R22
    BRBC    Z, Thigh        ; 8 Bits abgearbeitet?
    RET
;-------------------------------------------------------------------------------

.endif

